# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliMode.Models import (
      MgmtModelsMode,
      ProviderAFTMode,
      ProviderSmashMode,
      ProviderSysdbMode,
)

class MgmtModelsSaveMode( MgmtModelsMode, CliSave.Mode ):
   def __init__( self, param ):
      MgmtModelsMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

class ProviderAFTSaveMode( ProviderAFTMode, CliSave.Mode ):
   def __init__( self, param ):
      ProviderAFTMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

class ProviderSmashSaveMode( ProviderSmashMode, CliSave.Mode ):
   def __init__( self, param ):
      ProviderSmashMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

class ProviderSysdbSaveMode( ProviderSysdbMode, CliSave.Mode ):
   def __init__( self, param ):
      ProviderSysdbMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

CliSave.GlobalConfigMode.addChildMode( MgmtModelsSaveMode )
MgmtModelsSaveMode.addCommandSequence( "Mgmt.models" )

MgmtModelsSaveMode.addChildMode( ProviderAFTSaveMode )
ProviderAFTSaveMode.addCommandSequence( 'Mgmt.models.provider.aft' )

MgmtModelsSaveMode.addChildMode( ProviderSmashSaveMode )
ProviderSmashSaveMode.addCommandSequence( 'Mgmt.models.provider.smash' )

MgmtModelsSaveMode.addChildMode( ProviderSysdbSaveMode )
ProviderSysdbSaveMode.addCommandSequence( 'Mgmt.models.provider.sysdb' )

@CliSave.saver( "Octa::Config", "mgmt/octa/config" )
def saveModels( octaConfig, root, sysdbRoot, options, requireMounts ):
   aftIPv4Unicast = octaConfig.aftOptions.ipv4Unicast
   aftIPv6Unicast = octaConfig.aftOptions.ipv6Unicast
   smashIncludes = octaConfig.option.get( 'smashincludes', '' )
   smashExcludes = octaConfig.option.get( 'smashexcludes', '' )
   sysdbExcludes = octaConfig.option.get( 'sysdbexcludes', '' )
   if smashIncludes or smashExcludes or sysdbExcludes or aftIPv4Unicast \
         or aftIPv6Unicast:
      parentMode = root[
         MgmtModelsSaveMode ].getOrCreateModeInstance( "api-provider" )

      if aftIPv4Unicast or aftIPv6Unicast:
         mode = parentMode[
            ProviderAFTSaveMode ].getOrCreateModeInstance( "provider-aft" )
         cmds = mode[ "Mgmt.models.provider.aft" ]

         if aftIPv4Unicast:
            cmds.addCommand( "ipv4-unicast" )

         if aftIPv6Unicast:
            cmds.addCommand( "ipv6-unicast" )


      if smashIncludes or smashExcludes:
         mode = parentMode[
            ProviderSmashSaveMode ].getOrCreateModeInstance( "provider-smash" )
         cmds = mode[ "Mgmt.models.provider.smash" ]

         if smashIncludes:
            smashIncludes = smashIncludes.split( ',' )
            for path in sorted( smashIncludes ):
               cmds.addCommand( "path {}".format( path ) )

         if smashExcludes:
            smashExcludes = smashExcludes.split( ',' )
            for path in sorted( smashExcludes ):
               cmds.addCommand( "path {} disabled".format( path ) )

      if sysdbExcludes:
         mode = parentMode[
            ProviderSysdbSaveMode ].getOrCreateModeInstance( "provider-sysdb" )
         cmds = mode[ "Mgmt.models.provider.sysdb" ]

         sysdbExcludes = sysdbExcludes.split( ',' )
         for path in sorted( sysdbExcludes ):
            cmds.addCommand( "path {} disabled".format( path ) )
   elif options.saveAll:
      parentMode = root[
         MgmtModelsSaveMode ].getOrCreateModeInstance( "api-provider" )
      parentMode[ "Mgmt.models" ].addCommand( "no provider aft" )
      parentMode[ "Mgmt.models" ].addCommand( "no provider smash" )
      parentMode[ "Mgmt.models" ].addCommand( "no provider sysdb" )

