#!/usr/bin/env python
# Copyright (c) 2009-2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
import Toggles.MlagToggleLib
from IntfCliSave import IntfConfigMode
from CliMode.Mlag import MlagMode
import Tac

class MlagConfigMode( MlagMode, CliSave.Mode ):

   def __init__( self, param ):
      MlagMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )


CliSave.GlobalConfigMode.addChildMode( MlagConfigMode, 
                                       after=[ IntfConfigMode ] )
MlagConfigMode.addCommandSequence( 'Mlag.global' )

@CliSave.saver( 'Mlag::Config', 'mlag/config',
                requireMounts = ( 'mlag/hardware/status', ) )
def saveMlag( cfg, root, sysdbRoot, options,
              requireMounts ):
   saveAll = options.saveAll
   saveAllDetail = options.saveAllDetail
   # Display config only if mlag is supported by the hardware
   mlagHardwareStatus = requireMounts[ 'mlag/hardware/status' ]
   if not mlagHardwareStatus.mlagSupported:
      saveAll = False
      saveAllDetail = False
   toRun = []
   if cfg.domainId != "":
      toRun.append( "domain-id %s" % cfg.domainId )
   elif saveAll:
      toRun.append( "no domain-id" )
   if cfg.heartbeatInterval != cfg.heartbeatIntervalDefault or saveAll:
      if cfg.heartbeatInterval == 0:
         toRun.append( "heartbeat-interval disabled" )
      else:
         toRun.append( "heartbeat-interval %d" % cfg.heartbeatInterval )
   if cfg.heartbeatTimeout != 0:
      # Default is not displayed in saveAll because this is a hidden command.
      toRun.append( "heartbeat-timeout %d" % cfg.heartbeatTimeout )
   if cfg.localIntfId:
      toRun.append( "local-interface %s" % cfg.localIntfId )
   elif saveAll:
      toRun.append( "no local-interface" )
   if cfg.peerAddress != '0.0.0.0':
      toRun.append( "peer-address %s" % cfg.peerAddress )
   elif saveAll:
      toRun.append( "no peer-address" )
   if cfg.heartbeatPeerAddress.address != '0.0.0.0':
      cmd = "peer-address heartbeat %s" % cfg.heartbeatPeerAddress.address
      if cfg.heartbeatPeerAddress.vrf:
         cmd += " vrf " + cfg.heartbeatPeerAddress.vrf
      toRun.append( cmd )
   elif saveAll:
      toRun.append( "no peer-address heartbeat" )
   if cfg.primaryPriority != cfg.primaryPriorityDefault: # hidden
      toRun.append( "primary-priority %d" % cfg.primaryPriority )
   if cfg.peerLinkIntfId:
      toRun.append( "peer-link %s" % cfg.peerLinkIntfId )
   elif saveAll:
      toRun.append( "no peer-link" )
   if cfg.dualPrimaryDetectionDelay:
      cmd = "dual-primary detection delay %d" % cfg.dualPrimaryDetectionDelay
      if cfg.dualPrimaryAction == "dualPrimaryActionErrdisableAllInterfaces":
         cmd += " action errdisable all-interfaces"
      toRun.append( cmd )
   elif saveAll:
      toRun.append( "no dual-primary detection" )
   if cfg.dualPrimaryMlagRecoveryDelay or cfg.dualPrimaryNonMlagRecoveryDelay:
      mlagRecoveryDelay = cfg.dualPrimaryMlagRecoveryDelay
      nonMlagRecoveryDelay = cfg.dualPrimaryNonMlagRecoveryDelay
      cmd = "dual-primary recovery delay mlag %d non-mlag %d" \
            % ( mlagRecoveryDelay, nonMlagRecoveryDelay )
      toRun.append( cmd )
   elif saveAll and Toggles.MlagToggleLib.toggleRecoveryDelayEnabled():
      toRun.append( "no dual-primary recovery delay" )
   if cfg.reloadDelayMlagConfigured:
      if cfg.reloadDelay.delay == cfg.reloadDelayInfinity:
         toRun.append( "reload-delay mlag infinity" )
      else:
         toRun.append( "reload-delay mlag %d" % cfg.reloadDelay.delay )
   else:
      if cfg.reloadDelay.delay == cfg.reloadDelayInfinity:
         toRun.append( "reload-delay infinity" )
      elif cfg.reloadDelay.reloadDelayType == "reloadDelayConfigured":
         toRun.append( "reload-delay %d" % cfg.reloadDelay.delay )
      elif saveAll:
         toRun.append( "no reload-delay" )
   if cfg.reloadDelayNonMlag.reloadDelayType == "reloadDelayConfigured":
      if cfg.reloadDelayNonMlag.delay == cfg.reloadDelayInfinity:
         toRun.append( "reload-delay non-mlag infinity" )
      else:
         toRun.append( "reload-delay non-mlag %d" % cfg.reloadDelayNonMlag.delay )
   elif saveAll:
      toRun.append( "no reload-delay non-mlag" )
   if cfg.lacpStandby:
      toRun.append( "reload-delay mode lacp standby" )
   elif saveAll:
      toRun.append( "no reload-delay mode" )
   if cfg.minVersion != cfg.minVersionDefault:
      # Default is not displayed in saveAll because this is a hidden command.
      toRun.append( "min-version %d" % cfg.minVersion )
   if cfg.maxVersion != cfg.maxVersionDefault:
      # Default is not displayed in saveAll because this is a hidden command.
      toRun.append( "max-version %d" % cfg.maxVersion )
   
   tacFastMacRedirectionConfig = Tac.Type( "Mlag::FastMacRedirectionConfig" )
   if mlagHardwareStatus.fastMacRedirectionConfigurable:
      cmd = None
      if cfg.fastMacRedirectionConfig == \
         tacFastMacRedirectionConfig.fastMacRedirectionConfigured:
         cmd = "inactive mac-address destination peer-link indirect"
      elif cfg.fastMacRedirectionConfig == \
         tacFastMacRedirectionConfig.fastMacRedirectionUnconfigured:
         cmd = "inactive mac-address destination peer-link direct"
      elif saveAll:
         cmd = "no inactive mac-address destination peer-link"

      if cmd:
         toRun.append( cmd )

   if cfg.enabled == False:
      toRun.append( "shutdown" )
   elif saveAll:
      toRun.append( "no shutdown" )
   if toRun:
      mode = root[ MlagConfigMode ].getOrCreateModeInstance( None )
      cmds = mode[ 'Mlag.global' ]
      for c in toRun:
         cmds.addCommand( c )
