# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave, Management, Tac

class MgmtDefaultsConfigMode( Management.MgmtConfigMode ):

   def __init__( self, param ):
      Management.MgmtConfigMode.__init__( self, "defaults" )

CliSave.GlobalConfigMode.addChildMode( MgmtDefaultsConfigMode )
MgmtDefaultsConfigMode.addCommandSequence( 'Mgmt.defaults' )

@CliSave.saver( 'Mgmt::Defaults::Config', 'mgmt/defaults/config' )
def saveMgmtDefaults( defaultsConfig, root, sysdbRoot, options ):
   if defaultsConfig.hashAlgorithm == 'md5':
      mode = root[ MgmtDefaultsConfigMode ].getOrCreateModeInstance( 'defaults' )
      cmds = mode[ 'Mgmt.defaults' ]
      cmds.addCommand( "secret hash md5" )
   elif options.saveAll:
      mode = root[ MgmtDefaultsConfigMode ].getOrCreateModeInstance( 'defaults' )
      cmds = mode[ 'Mgmt.defaults' ]
      cmds.addCommand( "secret hash sha512" )
