# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliMode.McsClient import McsServiceClientMode, McsServiceClientSecondaryCvxMode
from CliSavePlugin.ControllerClient import saveMgmtCvxConfigHelper
import Tac

# pylint: disable-msg=W0223
class McsServiceClientConfigSaveMode( McsServiceClientMode,
      CliSave.Mode ):
   def __init__( self, param ):
      McsServiceClientMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

CliSave.GlobalConfigMode.addChildMode( McsServiceClientConfigSaveMode )
McsServiceClientConfigSaveMode.addCommandSequence( "McsServiceClient.config" )

class McsServiceClientSecondaryCvxConfigSaveMode( McsServiceClientSecondaryCvxMode,
      CliSave.Mode ):
   def __init__( self, param ):
      McsServiceClientSecondaryCvxMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

McsServiceClientConfigSaveMode.addChildMode(
      McsServiceClientSecondaryCvxConfigSaveMode )

McsServiceClientSecondaryCvxConfigSaveMode.addCommandSequence(
      "McsServiceClientSecondaryCvx.config" )

@CliSave.saver( "Mcs::Client::Config", "mcs/switch/config" )
def saveMcsServiceClientConfig( entity, root, sysdbRoot, options, requireMounts ):
   cmds = []

   if entity.enabled or options.saveAll:
      cmds.append( "%sshutdown" % ( "no " if entity.enabled else "" ) )

   if cmds:
      mcsServiceClientMode = root[
            McsServiceClientConfigSaveMode ].getOrCreateModeInstance( "mcs-client" )
      mcsServiceClientMode = mcsServiceClientMode[ "McsServiceClient.config" ]
      for cmd in cmds:
         mcsServiceClientMode.addCommand( cmd )

clusterDefaultName = Tac.Value( "Controller::Constants" ).clusterDefaultName
@CliSave.saver( "ControllerClient::Config", "mcs/switch/controller/config" )
def saveMcsServiceClientSecondaryCvxConfig(
      entity, root, sysdbRoot, options, requireMounts ):

   cmds = saveMgmtCvxConfigHelper( entity, root, sysdbRoot, options )

   if cmds or ( entity.clusterName and entity.clusterName != clusterDefaultName ):
      mcsServiceClientMode = root[
            McsServiceClientConfigSaveMode ].getOrCreateModeInstance( "mcs-client" )

      secondaryCvxMode = mcsServiceClientMode[
            McsServiceClientSecondaryCvxConfigSaveMode ]
      if not entity.clusterName:
         secondaryCvxMode = secondaryCvxMode.getOrCreateModeInstance(
               clusterDefaultName )
      else:
         secondaryCvxMode = secondaryCvxMode.getOrCreateModeInstance(
               entity.clusterName )
      secondaryCvxMode = secondaryCvxMode[ "McsServiceClientSecondaryCvx.config" ]

      for cmd in cmds:
         secondaryCvxMode.addCommand( cmd )
