# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliMode.Mcs import McsServiceMode
from CliSavePlugin.Controllerdb import CvxConfigMode
from CliSavePlugin.Controllerdb import controllerConfigPath
from CliSavePlugin.Controllerdb import getClusterName

# pylint: disable-msg=W0223
class McsServiceConfigSaveMode( McsServiceMode, CliSave.Mode ):
   def __init__( self, param ):
      McsServiceMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

CvxConfigMode.addChildMode( McsServiceConfigSaveMode, after=[ 'cvx' ] )
McsServiceConfigSaveMode.addCommandSequence( "McsService.config" )
CliSave.GlobalConfigMode.addCommandSequence( "McsServiceGlobal.config" )

@CliSave.saver( "Mcs::CliConfig", "mcs/config/cli",
                requireMounts=( controllerConfigPath, ) )
def saveMcsServiceConfig( entity, root, sysdbRoot, options, requireMounts ):
   cmds = []

   if entity.redisPassword:
      cmds.append( "redis password 7 %s" % CliSave.sanitizedOutput( options,
                                                           entity.redisPassword ) )

   if entity.enabled or options.saveAll:
      cmds.append( "%sshutdown" % ( "no " if entity.enabled else "" ) )
   if cmds:
      cvxClusterName = getClusterName( requireMounts[ controllerConfigPath ] )
      mode = root[ CvxConfigMode ].getOrCreateModeInstance(
               CvxConfigMode.modeName( cvxClusterName ) )
      mcsServiceMode = mode[ McsServiceConfigSaveMode ]
      mcsServiceMode = mcsServiceMode.getOrCreateModeInstance( "cvx-mcs" )
      mcsServiceMode = mcsServiceMode[ "McsService.config" ]
      for cmd in cmds:
         mcsServiceMode.addCommand( cmd )
