# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
import IntfCliSave
import Tac
import Cell 
from Ark import getPlatform

IntfCliSave.IntfConfigMode.addCommandSequence( 'Mgmtactive.config' )
@CliSave.saver( 'Interface::MgmtActiveIntfConfigDir',
                'interface/config/eth/managementactive',
                requireMounts = ( 'interface/status/all', ) )
def saveMa0IntfConfig( entity, root, sysdbRoot, options,
                       requireMounts ):
   if entity.intfConfig:
      IntfCliSave.saveIntfConfig( entity.intfConfig, root, sysdbRoot, options,
                                  requireMounts )

      mode = root[ IntfCliSave.IntfConfigMode ].getOrCreateModeInstance(
                   entity.intfConfig.intfId )
      cmds = mode[ 'Mgmtactive.config' ]
      if getPlatform() == 'veos':
         if entity.intfConfig.addr != Tac.Type( "Arnet::EthAddr" ).ethAddrZero:
            cmds.addCommand( 'mac-address %s' % entity.intfConfig.addr )
         elif options.saveAll:
            cmds.addCommand( 'no mac-address' )

      elif Cell.cellType() == "supervisor": 
         # Runs on modular DUT
         if entity.intfConfig.backupLinkStandby:
            if entity.intfConfig.backupLinkFallbackDelay == (
                  Tac.endOfTime ):
               cmds.addCommand( 'backup-link standby fallback-delay infinity' )
            elif ( options.saveAll or entity.intfConfig.backupLinkFallbackDelay !=
                 entity.intfConfig.defaultFallbackDelay ):
               cmds.addCommand( 'backup-link standby fallback-delay %u'
                  % entity.intfConfig.backupLinkFallbackDelay )
            else:
               cmds.addCommand( 'backup-link standby' )
         elif options.saveAll:
            cmds.addCommand( 'no backup-link standby' )
