#!/usr/bin/env python
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, CliSave, re
from CliMode.IntfMaintenanceProfile import IntfMaintenanceProfileMode
from CliMode.MaintenanceModeCliSaveLib import MaintenanceConfigMode
from CliMode.IntfGroup import IntfGroupMode
from Intf.IntfRange import intfListToCanonical
from IntfCliSave import IntfConfigMode
   
#-----------------------------------------------------------------
# CliSave Plugin for Interface Maintenance Groups
#-----------------------------------------------------------------
class IntfGroupConfigMode( IntfGroupMode, CliSave.Mode ):

   def __init__( self, param ):
      IntfGroupMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

CliSave.GlobalConfigMode.addChildMode( IntfGroupConfigMode,
                                       after=[ IntfConfigMode ] )
IntfGroupConfigMode.addCommandSequence( 'IntfGroup.configDir' )

@CliSave.saver( 'IntfGroup::ConfigDir', 'group/config/interface',
                requireMounts = ( 'interface/status/all',
                                  'maintenance/group/config' ) )
def saveIntfGroupConfig( entity, root, sysdbRoot, options, requireMounts ):
   maintenanceGroupDir = requireMounts[ 'maintenance/group/config' ]
   groupOrigin = Tac.Type( "Group::GroupOrigin" )
   for groupConfig in entity.config.values():
      if groupConfig.origin == groupOrigin.dynamic:
         continue
      group = groupConfig.groupName
      mode = root[ IntfGroupConfigMode ].getOrCreateModeInstance( group )
      cmds = mode[ 'IntfGroup.configDir' ]
      member = entity.config[ group ]
      if groupConfig.origin == groupOrigin.userConfigured:
         ethIntfDir = requireMounts[ 'interface/status/all' ]
         allIntf = member.intf.keys()
         nonExistingIntfs = []
         for intf in member.intf.keys():
            if re.match( 'Ethernet*', intf ):
               if intf not in ethIntfDir.intfStatus.keys():
                  nonExistingIntfs.append( intf )
                  allIntf.remove( intf )      
         intfs = intfListToCanonical( allIntf )
         for intf in intfs:
            cmds.addCommand( 'interface %s' % intf ) 
         for intf in nonExistingIntfs:
            cmds.addCommand( 'interface %s' % intf )
      intfProfileType = 'profileTypeInterface'
      bgpProfileType = 'profileTypeBgp'
      maintenanceGroup = maintenanceGroupDir.maintenanceGroup.get( member.key )
      if maintenanceGroup:
         for profile in maintenanceGroup.profile.keys():
            if ( profile.type == intfProfileType ):
               cmds.addCommand( 
                  'maintenance profile interface %s' %( profile.name ) )
            elif ( profile.type == bgpProfileType ):
               cmds.addCommand( 'maintenance profile bgp %s' %( profile.name ) )

      #XXX Temporary hack to avoid 'maintenance' config mode following this from 
      # cribbing for IncompleteCommandError
      cmds.addCommand( 'exit' )

#--------------------------------------------------------------------
# CliSave Plugin for Interface Maintenance Profile
#--------------------------------------------------------------------
class IntfMaintenanceProfileConfigMode( IntfMaintenanceProfileMode, CliSave.Mode ):
   
   def __init__( self, param ):
      IntfMaintenanceProfileMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

CliSave.GlobalConfigMode.addChildMode( MaintenanceConfigMode,
                                       after=[ IntfConfigMode ] )
MaintenanceConfigMode.addCommandSequence( 'DefaultProfile' )

defaultProfileName = \
   Tac.Type( 'Maintenance::Profile::DefaultProfile' ).systemDefaultProfileName

@CliSave.saver( 'Maintenance::Profile::DefaultProfile',
                'maintenance/profile/config/default/interface' )
def saveDefaultInterfaceProfile( entity, root, sysdb, options ):
   if entity.profileName != defaultProfileName:
      mode = root[ MaintenanceConfigMode ].getOrCreateModeInstance(
            'maintenance' )
      cmds = mode[ 'DefaultProfile' ]
      cmds.addCommand( 'profile interface %s default' % entity.profileName )

MaintenanceConfigMode.addChildMode( IntfMaintenanceProfileConfigMode )
IntfMaintenanceProfileConfigMode.addCommandSequence( 'IntfProfile.configDir' )

@CliSave.saver( 'IntfMaintenanceProfile::ConfigDir',
                'maintenance/profile/config/interface' )
def saveIntfProfileConfig( entity, root, sysdb, options ):
   default = options.saveAll or options.saveAllDetail 
   for profile in entity.config:
      if profile != defaultProfileName:
         mode = root[ MaintenanceConfigMode ].getOrCreateModeInstance( 
            'maintenance' )
         profileMode = mode[
            IntfMaintenanceProfileConfigMode ].getOrCreateModeInstance( profile )
         cmds = profileMode[ 'IntfProfile.configDir' ]
         member = entity.config[ profile ]
         if member.rateMonLoadInterval != member.defaultLoadInterval:
            cmds.addCommand( 'rate-monitoring load-interval %s' % ( 
                  int ( member.rateMonLoadInterval ) ) )
         elif default:
            cmds.addCommand( 'rate-monitoring load-interval %s' % (
                  int ( member.defaultLoadInterval ) ) )
         if member.rateMonThresholdInKbps != member.defaultRateMonThreshold:
            cmds.addCommand( 'rate-monitoring threshold %s' % ( 
                  int (  member.rateMonThresholdInKbps ) ) )
         elif default:
            cmds.addCommand( 'rate-monitoring threshold %s' % ( 
                  int (  member.defaultRateMonThreshold ) ) )
         if ( member.shutdown == True ):
            cmds.addCommand( 'shutdown max-delay %s' % int ( 
                  member.shutdownMaxDelay ) )
         elif default:
            cmds.addCommand( 'no shutdown' )
