# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
import IntfCliSave

IntfCliSave.IntfConfigMode.addCommandSequence( 'MacsecProxy.config' )

@CliSave.saver( 'MacsecProxy::Config', 'macsecproxy/config' )
def saveMacsecProxyConfig( entity, root, sysdbRoot, options,
                           requireMounts ):
   for intfName in entity.proxyConfig.keys():
      cmd = "mac security proxy patch "
      mode = root[ IntfCliSave.IntfConfigMode ].getOrCreateModeInstance( intfName )
      intfCmds = mode[ 'MacsecProxy.config' ]

      if entity.proxyConfig[ intfName ].clientIntf != "":
         intfCmds.addCommand( cmd + entity.proxyConfig[ intfName ].patchIntf +
                     " external " + entity.proxyConfig[ intfName ].clientIntf )
      else:
         intfCmds.addCommand( cmd + entity.proxyConfig[ intfName ].patchIntf )
