# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, CliSave

CliSave.GlobalConfigMode.addCommandSequence( 'MacFlap.logging', 
      after=[ 'Ebra.agingTime' ] )

@CliSave.saver( 'MacFlap::Config', 'macflap/config' )
def saveMacFlapConfig( entity, root, sysdbRoot, options ):
   cmds = root[ 'MacFlap.logging' ]
   if entity.enabled == False:
      cmds.addCommand( "no mac address-table notification host-flap logging" )
   elif options.saveAll:
      cmds.addCommand( "mac address-table notification host-flap logging" )
   if int( entity.flapDelta ) != 15 or options.saveAll:
      cmds.addCommand( "mac address-table notification "
            + "host-flap detection window " + str( int( entity.flapDelta ) ) )
   if int( entity.flapMoves ) != 5 or options.saveAll:
      cmds.addCommand( "mac address-table notification host-flap detection moves " +
                        str( int( entity.flapMoves ) ) )
