# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from IntfCliSave import IntfConfigMode
import IntfCliSave

IntfConfigMode.addCommandSequence(
   'LoopbackIntf.config', after=[ 'Arnet.intf' ] )

@CliSave.saver( 'Interface::LoopbackIntfConfig', 'interface/config/loopback/intf',
                attrName='intfConfig', requireMounts=( 'interface/status/all', ) )
def saveLoopbackIntfConfig( entity, root, sysdbRoot, options, requireMounts ):
   # Save the baseclass (Interface::IntfConfig) attributes.
   IntfCliSave.saveIntfConfig( entity, root, sysdbRoot, options, requireMounts )

   cliMode = root[ IntfConfigMode ].getOrCreateModeInstance( entity.intfId )
   cmds = cliMode[ 'LoopbackIntf.config' ]

   if entity.hwFwdIdEnabled:
      cmds.addCommand( 'hardware forwarding id' )
   elif options.saveAll:
      cmds.addCommand( 'no hardware forwarding id' )
