# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

#-------------------------------------------------------------------------------
# This module implements CliSave for the link-flap commands
#-------------------------------------------------------------------------------
import CliSave
from IntfCliSave import IntfConfigMode
from CliMode.LinkFlapDetection import LinkFlapMode

CliSave.GlobalConfigMode.addCommandSequence( 'LinkFlap.config' )

class LinkFlapConfigMode( LinkFlapMode, CliSave.Mode ):
   def __init__( self, param ):
      LinkFlapMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

CliSave.GlobalConfigMode.addChildMode( LinkFlapConfigMode, 
                                       before=[ IntfConfigMode ] )
LinkFlapConfigMode.addCommandSequence( 'linkFlap.profileConfig' )
IntfConfigMode.addCommandSequence( 'linkFlap.intfConfig' )

@CliSave.saver( 'LinkFlap::Config', 'interface/errdisable/linkFlapConfig' )
def saveLinkFlapConfig( entity, root, sysdbRoot, options ):
   cmds = root[ 'LinkFlap.config' ]

   if entity.maxFlaps != entity.maxFlapsDefault or \
      entity.interval != entity.intervalDefault or options.saveAll:
      cmds.addCommand( 'errdisable flap-setting cause link-flap max-flaps %d time %d'
         % ( entity.maxFlaps, entity.interval ) )

@CliSave.saver( 'LinkFlap::Config', 'interface/errdisable/linkFlapConfig' )
def saveProfileConfig( entity, root, sysdbRoot, options ):
   if entity.profileConfig or entity.defaultProfileList:
      linkFlapMode = \
            root[ LinkFlapConfigMode ].getOrCreateModeInstance( entity.name )
      profileCmds = linkFlapMode[ 'linkFlap.profileConfig' ]
      for profileConfig in sorted( entity.profileConfig.itervalues() ):
         profileCmds.addCommand( 
               'profile %s max-flaps %d time %d violations %d intervals %d' 
               % ( profileConfig.profileName, profileConfig.maxFlaps, 
                   profileConfig.interval,
                   profileConfig.violations,
                   profileConfig.trackedIntervals ) )
      if entity.defaultProfileList:
         defaultProfileListCmd = 'default-profiles'
         for profileName in sorted( entity.defaultProfileList ):
            defaultProfileListCmd = defaultProfileListCmd + ' ' + profileName
         profileCmds.addCommand( defaultProfileListCmd )
   

@CliSave.saver( 'LinkFlap::Config', 'interface/errdisable/linkFlapConfig' )
def saveIntfConfig( entity, root, sysdbRoot, options ):

   for intfName in entity.intfConfig:
      intfMode = root[ IntfConfigMode ].getOrCreateModeInstance( intfName )
      intfCmds = intfMode[ 'linkFlap.intfConfig' ]
      intfConfig = entity.intfConfig[ intfName ]
      if intfConfig.enabled is False:
         intfCmds.addCommand( 'no monitor link-flap' )
      else:
         if intfConfig.profileList:
            profileListCmd = 'monitor link-flap profiles'
            for profileName in entity.intfConfig[ intfName ].profileList:
               profileListCmd = profileListCmd + ' ' + profileName
            intfCmds.addCommand( profileListCmd )
         else:
            intfCmds.addCommand( 'monitor link-flap' )
