# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliMode.Launcher import MonitorSystemMode, MemoryExhaustionMode

class MonitorSystemConfigMode( MonitorSystemMode, CliSave.Mode ):
   def __init__( self, param ):
      MonitorSystemMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

class MemoryExhaustionConfigMode( MemoryExhaustionMode, CliSave.Mode ):
   def __init__( self, param ):
      MemoryExhaustionMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

CliSave.GlobalConfigMode.addChildMode( MonitorSystemConfigMode )
MemoryExhaustionConfigMode.addCommandSequence( "MonitorSystem.config" )
MonitorSystemConfigMode.addChildMode( MemoryExhaustionConfigMode )
MemoryExhaustionConfigMode.addCommandSequence( "MemoryExhaustion.config" )

@CliSave.saver( 'ProcMgr::LowMemoryModeConfig', 'sys/config/lowMemConfig' )
def saveLowMemModeConfig( config, root, sysdbRoot, options,
                      requireMounts ):
   monitorSysMode = root[ MonitorSystemConfigMode ].getSingletonInstance()
   memExhaustionMode = monitorSysMode[
         MemoryExhaustionConfigMode ].getSingletonInstance()
   cmds = memExhaustionMode[ 'MemoryExhaustion.config' ]
   # default value of enable is False. Only add it to show running config if set
   # or if we have save all or save all detail
   if config.enable:
      cmds.addCommand( 'action agent non-critical hold-down' )
   else:
      if options.saveAll or options.saveAllDetail:
         cmds.addCommand( 'no action agent non-critical hold-down' )
