#!/usr/bin/env python
# Copyright (c) 2009, 2010, 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
import IntfCliSave
import LanzLib

IntfCliSave.IntfConfigMode.addCommandSequence( 'Lanz.config' )

@CliSave.saver( 'Lanz::Config', 'lanz/config',
                requireMounts = ( 'lanz/hardware/status', ) )
def saveLanzIntfConfig( entity, root, sysdbRoot, options,
                        requireMounts ):

   # Save interface specific settings
   lanzHwStatus = None
   for intfName in entity.portConfig:
      portConfig = entity.portConfig.get( intfName )
      if portConfig and intfName != 'Cpu' and intfName != 'Fabric':
         mode = root[ IntfCliSave.IntfConfigMode ].getOrCreateModeInstance(intfName)
         intfCmds = mode[ 'Lanz.config' ]
         if portConfig.disabled:
            intfCmds.addCommand( 'no queue-monitor length' )
         if not portConfig.mirroringEnabled:
            if lanzHwStatus is None:
               lanzHwStatus = requireMounts[ 'lanz/hardware/status' ]
            if lanzHwStatus.mirroringSupported:
               intfCmds.addCommand( 'no queue-monitor length mirror' )
         if portConfig.validThreshold:
            if lanzHwStatus is None:
               lanzHwStatus = requireMounts[ 'lanz/hardware/status' ]
            defHighThreshold = LanzLib.getDefaultHighThreshold( entity,
                                                                lanzHwStatus )
            defLowThreshold = LanzLib.getDefaultLowThreshold( entity,
                                                              lanzHwStatus )
            if ( portConfig.highThreshold != defHighThreshold or \
                 portConfig.lowThreshold != defLowThreshold ):
               if lanzHwStatus.lowThresholdSupported:
                  intfCmds.addCommand( 'queue-monitor length thresholds %d %d'
                              %( portConfig.highThreshold,
                                 portConfig.lowThreshold ) )
               else:
                  intfCmds.addCommand( 'queue-monitor length threshold %d'
                              %( portConfig.highThreshold ) )

