#!/usr/bin/env python
# Copyright (c) 2009, 2010, 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from IntfCliSave import IntfConfigMode
import CliSave

IntfConfigMode.addCommandSequence( 'Mlag.lagIntf', after=[ 'Lag.lagIntf' ] )

@CliSave.saver( 'Mlag::Config', 'mlag/config',
                requireMounts = ( 'mlag/hardware/status',
                                  'interface/config/eth/lag' ) )
def saveLagIntfMlag( entity, root, sysdbRoot, options,
                     requireMounts ):
   # Display config only if mlag is supported by the hardware
   mlagHardwareStatus = requireMounts[ 'mlag/hardware/status' ]
   saveAll = options.saveAll
   saveAllDetail = options.saveAllDetail

   if not mlagHardwareStatus.mlagSupported:
      saveAll = False
      saveAllDetail = False

   if saveAll:
      # Get the list of interface names from interface/config/eth/lag 
      lagEthIntfStatusDir = requireMounts[ 'interface/config/eth/lag' ]
      cfgLagNames = lagEthIntfStatusDir
   else:
      cfgLagNames = entity.intfConfig

   for k in cfgLagNames:
      v = entity.intfConfig.get( k )
      if v:
         cmd = 'mlag %s' % v
      elif saveAll:
         cmd = 'no mlag'
      else:
         continue

      mode = root[ IntfConfigMode ].getOrCreateModeInstance( k )
      cmds = mode[ 'Mlag.lagIntf' ]
      cmds.addCommand( cmd )
