# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import CliSave
from CliMode.RouterL2Vpn import RoutingL2VpnMode

class RouterL2VpnBaseConfigMode( RoutingL2VpnMode, CliSave.Mode ):
   def __init__( self, param ):
      RoutingL2VpnMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

CliSave.GlobalConfigMode.addChildMode( RouterL2VpnBaseConfigMode )
RouterL2VpnBaseConfigMode.addCommandSequence( 'l2vpn.config' )

def saveSingleConfig( root, cmd ):
   mode = root[ RouterL2VpnBaseConfigMode ].getSingletonInstance()
   saveRoot = mode[ 'l2vpn.config' ]
   saveRoot.addCommand( cmd )

@CliSave.saver( 'Routing::L2Vpn::Config', 'routing/l2vpn/config' )
def saveL2VpnConfig( entity, root, sysdbRoot, options ):
   if entity.arpProxyPrefixList != '':
      cmd = 'arp proxy prefix-list %s' % entity.arpProxyPrefixList
      saveSingleConfig( root, cmd )
   elif options.saveAll:
      cmd = 'no arp proxy prefix-list'
      saveSingleConfig( root, cmd )

   if entity.ndProxyPrefixList != "":
      cmd = "nd proxy prefix-list %s" % entity.ndProxyPrefixList
      saveSingleConfig( root, cmd )
   elif options.saveAll:
      cmd = "no nd proxy prefix-list"
      saveSingleConfig( root, cmd )

   if entity.arpSelectiveInstall != False:
      cmd = 'arp selective-install'
      saveSingleConfig( root, cmd )
   elif options.saveAll:
      cmd = 'no arp selective-install'
      saveSingleConfig( root, cmd )

   if entity.rsFloodingDisabled != False:
      cmd = 'nd rs flooding disabled'
      saveSingleConfig( root, cmd )
   elif options.saveAll:
      cmd = 'no nd rs flooding disabled'
      saveSingleConfig( root, cmd )

   if entity.dadFloodingDisabled != False:
      cmd = 'nd dad flooding disabled'
      saveSingleConfig( root, cmd )
   elif options.saveAll:
      cmd = 'no nd dad flooding disabled'
      saveSingleConfig( root, cmd )

   if entity.virtualRouterNaFloodingDisabled != False:
      cmd = 'virtual-router neighbor advertisement flooding disabled'
      saveSingleConfig( root, cmd )
   elif options.saveAll:
      cmd = 'no virtual-router neighbor advertisement flooding disabled'
      saveSingleConfig( root, cmd )

   if entity.virtualRouterGarpFloodingDisabled != False:
      cmd = 'virtual-router arp advertisement flooding disabled'
      saveSingleConfig( root, cmd )
   elif options.saveAll:
      cmd = 'no virtual-router arp advertisement flooding disabled'
      saveSingleConfig( root, cmd )
