# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliSavePlugin.IraCliSave import RouterKernelCliSaveMode
from CliMode.KernelFib import RouterKernelAfMode

class RouterKernelAfCliSaveMode( RouterKernelAfMode, CliSave.Mode ):
   def __init__( self, param ):
      RouterKernelAfMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

RouterKernelCliSaveMode.addChildMode( RouterKernelAfCliSaveMode )
RouterKernelAfCliSaveMode.addCommandSequence( 'Router.kernel.ipv4' )
RouterKernelAfCliSaveMode.addCommandSequence( 'Router.kernel.ipv6' )

@CliSave.saver( 'KernelFib::KernelRouteConfigDir', 'routing/kernel/config' )
def saveRouterKernelConfig( entity, root, sysdbRoot, options ):
   for vrfName in sorted( entity.vrfConfig ):
      vrf = entity.vrfConfig[ vrfName ]
      vrfMode = root[ RouterKernelCliSaveMode ].\
                getOrCreateModeInstance( ( vrfName ) )
      vrfAfMode = vrfMode[ RouterKernelAfCliSaveMode ].\
                  getOrCreateModeInstance( ( vrfName, 'ipv4' ) )
      cmds = vrfAfMode[ 'Router.kernel.ipv4' ]
      if vrf.preference != 40 or options.saveAll:
         cmds.addCommand( 'distance %s' % vrf.preference )

@CliSave.saver( 'KernelFib::KernelRouteConfigDir', 'routing6/kernel/config' )
def saveRouter6KernelConfig( entity, root, sysdbRoot, options ):
   for vrfName in sorted( entity.vrfConfig ):
      vrf = entity.vrfConfig[ vrfName ]
      vrfMode = root[ RouterKernelCliSaveMode ].\
                getOrCreateModeInstance( ( vrfName ) )
      vrfAfMode = vrfMode[ RouterKernelAfCliSaveMode ].\
                  getOrCreateModeInstance( ( vrfName, 'ipv6' ) )
      cmds = vrfAfMode[ 'Router.kernel.ipv6' ]
      if vrf.preference != 40 or options.saveAll:
         cmds.addCommand( 'distance %s' % vrf.preference )
