# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from IntfCliSave import IntfConfigMode
from CliMode.Ira import VrfDefinitionBaseMode

class VrfDefinitionCliSaveMode( VrfDefinitionBaseMode, CliSave.Mode ):
   def __init__( self, vrfName ):
      VrfDefinitionBaseMode.__init__( self, vrfName )
      CliSave.Mode.__init__( self, vrfName )

# VRF definition needs to come before interfaces so that the interfaces can
# use the VRFs

CliSave.GlobalConfigMode.addChildMode( VrfDefinitionCliSaveMode,
                                       before=[ IntfConfigMode ] )
VrfDefinitionCliSaveMode.addCommandSequence( 'vrfDef' )

class VrfAfMode( CliSave.Mode ):
   def enterCmd( self ):
      # FIXFIXFIX BUG29310.  need to create an overridable
      # exitCmd() in the CliSaveMode stuff, so that we can insert the
      # other config commands for this mode in between
      return 'address-family %s\n   exit-address-family' % self.param_ 

VrfDefinitionCliSaveMode.addChildMode( VrfAfMode )
VrfAfMode.addCommandSequence( 'vrfAfDef' )

@CliSave.saver( 'Ip::AllVrfConfig', 'ip/vrf/config' )
def saveVrfConfig( entity, root, sysdbRoot, options ):
   for vrfName in sorted( entity.vrf ):
      vrf = entity.vrf[ vrfName ]
      mode = root[ VrfDefinitionCliSaveMode ].getOrCreateModeInstance( vrfName )
      # Set the same deprecated value for all vrfs
      cmds = mode[ 'vrfDef' ]

      #  extract description from Sysdb and print it as CLI configuration
      if vrf.description != '':
         cmds.addCommand( 'description %s' % vrf.description )
      elif options.saveAll:
         cmds.addCommand( 'no description' )

         # VRF AF mode is not supported at this time, see comment in
         # IraVrfCli.py for why.

#      for af in sorted( vrf.addressFamily ):
#         if vrf.addressFamily[ af ]:
#            mode[ VrfAfMode ].getOrCreateModeInstance( af )

@CliSave.saver( 'Tac::Dir', 'ip/vrf/routeDistinguisherInputDir/config' )
def saveVrfRdConfig( entity, root, sysdbRoot, options ):
   vrfDefinitionRouteDistinguisherInput = entity.get( 'vrfDefinition' )
   if not vrfDefinitionRouteDistinguisherInput:
      return
   for vrfName in sorted( vrfDefinitionRouteDistinguisherInput.routeDistinguisher ):
      rd = vrfDefinitionRouteDistinguisherInput.routeDistinguisher[ vrfName ]
      # Not sure if mode is created here instead of saveVrfConfig() but if it is
      # the case, the correct deprecated mode will be set later by saveVrfConfig()
      mode = root[ VrfDefinitionCliSaveMode ].getOrCreateModeInstance( vrfName )
      cmds = mode[ 'vrfDef' ]
      assert rd != 'INVALID'
      cmds.addCommand( 'rd %s' % ( rd ) )
