# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave, Vlan
from IntfCliSave import IntfConfigMode

IntfConfigMode.addCommandSequence( 'IpSourceGuard.intf' )
CliSave.GlobalConfigMode.addCommandSequence( 'IpSourceGuard.config' )

@CliSave.saver( 'Ipsg::Config', 'security/ipsg/config' )
def saveIpsgConfig( entity, root, sysdbRoot, options, requireMounts ):
   intfConfigs = entity.ipsgEnabledIntf
   for intfId, intfConfig in intfConfigs.iteritems():
      saveIpsgIntf( intfConfig, intfId, root, sysdbRoot, options )

   cmds = root[ 'IpSourceGuard.config' ]
   if entity.ipsgDisabledVlan:
      vlanSet = Vlan.vlanSetToCanonicalString( entity.ipsgDisabledVlan.iterkeys() )
      cmds.addCommand( 'no ip verify source vlan %s' % vlanSet )
     
def saveIpsgIntf( entity, intfId, root, sysdbRoot, options ):
   mode = root[ IntfConfigMode ].getOrCreateModeInstance( intfId )
   cmds = mode[ 'IpSourceGuard.intf' ] 
   if entity:
      cmds.addCommand( 'ip verify source' )

