# Copyright (c) 2009, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, CliSave
from IntfCliSave import IntfConfigMode

IntfConfigMode.addCommandSequence( 'IntfSnmp.intf' )

def isInternal( intfName ):
   return intfName.startswith( "Internal" )

#-------------------------------------------------------------------------------
# Saves the state of an Interface::TestIntfConfig object.
#-------------------------------------------------------------------------------
@CliSave.saver( 'Snmp::Interface::Config', 'snmp/interface/config',
                requireMounts = ( 'interface/config/all', ) )
def saveIntfSnmpConfig( entity, root, sysdbRoot, options,
                        requireMounts ):
   saveAll = options.saveAll
   if saveAll:
      # Get the list of all interfaces 
      intfConfigDir = requireMounts[ 'interface/config/all' ]
      cfgIntfNames = ( intfName for intfName in intfConfigDir
                       if not isInternal( intfName ) )
   else:
      cfgIntfNames = entity.trapConfig

   for intfName in cfgIntfNames:
      intfId = Tac.Value( 'Arnet::IntfId', stringValue=intfName )
      trapCfg = entity.trapConfig.get( intfId )
      if trapCfg is None:
         if saveAll:
            trapCfg = Tac.newInstance( 'Snmp::Interface::TrapConfig' )
         else:
            continue
      mode = root[ IntfConfigMode ].getOrCreateModeInstance( intfName )
      cmds = mode[ 'IntfSnmp.intf' ]
      if trapCfg != Tac.Value( 'Snmp::Interface::TrapConfig' ):
         cmds.addCommand( '%ssnmp trap link-change' %
                          ( '' if trapCfg.linkStatusEnable else 'no ' ) )
      elif saveAll:
         # default case should always have the new syntax
         cmds.addCommand( 'snmp trap link-change' )


