# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import CliSave
from CliMode.IntfProfile import IntfProfileMode
from IntfCliSave import IntfConfigMode

class IntfProfileConfigMode( IntfProfileMode, CliSave.Mode ):
   def __init__( self, param ):
      IntfProfileMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

   def skipIfEmpty( self ):
      return True

CliSave.GlobalConfigMode.addChildMode( IntfProfileConfigMode,
                                       before=[ IntfConfigMode ] )
IntfProfileConfigMode.addCommandSequence( 'IntfProfile.config' )

# The "profile" command in the interfaces should be saved before interface commands.
# Since we don't have a way of saying "this should be the first command" without
# changing all the command sequences, mangle the name to make it more likely to be
# the first.
INTF_PROFILE_CMD_SEQ_NAME = '!!!!!!!!EthIntf.profile' 
IntfConfigMode.addCommandSequence( INTF_PROFILE_CMD_SEQ_NAME )

@CliSave.saver( 'IntfProfile::Config', 'interface/profile/config' )
def saveIntfProfileConfig( entity, root, sysdbRoot, options ):
   saveIntfProfileMode( entity, root )
   saveIntfProfileAssociations( entity, root )
   
def saveIntfProfileMode( entity, root ):
   for profileName, profile in entity.profile.iteritems():
      mode = root[ IntfProfileConfigMode ].getOrCreateModeInstance( profileName )
      cmds = mode[ 'IntfProfile.config' ]
      for command in profile.command.values():
         cmds.addCommand( 'command %s' % command )

def saveIntfProfileAssociations( entity, root ):
   for intf, profileAppCfg in entity.intfToAppliedProfile.iteritems():
      mode = root[ IntfConfigMode ].getOrCreateModeInstance( intf )
      cmds = mode[ INTF_PROFILE_CMD_SEQ_NAME ]
      cmds.addCommand( 'profile %s' % " ".join( profileAppCfg.profile.values() ) )

