#!/usr/bin/env python
# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
import Tac
from CliMode.IgmpProfile import IgmpProfileMode

class IgmpProfileConfigMode( IgmpProfileMode, CliSave.Mode ):
   def __init__( self, param ):
      IgmpProfileMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )
      
   def __cmp__( self, other ):
      return cmp( self.param_, other.param_ )

CliSave.GlobalConfigMode.addChildMode( IgmpProfileConfigMode )
IgmpProfileConfigMode.addCommandSequence( 'IgmpSnooping.profileConfig' )

@CliSave.saver( 'IgmpProfile::ProfileConfig' , 'igmpprofile/profileconfig' )
def saveProfileConfig( entity, root, sysdbRoot, options ):
   for profile in entity.profiles.itervalues():
      mode = root[ IgmpProfileConfigMode ].getOrCreateModeInstance( profile.name )
      cmds = mode[ 'IgmpSnooping.profileConfig' ]
      if profile.action == 'permit':
         cmds.addCommand( 'permit' )
      for r in profile.ranges:
         cmds.addCommand( "range %s %s" % ( r.lowAddr, r.highAddr ) )



