#!/usr/bin/env python
# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import CliSave
import IntfCliSave
from McastCommonCliLib import mcastRoutingSupported
from RoutingIntfUtils import allRoutingProtocolIntfNames

IntfCliSave.IntfConfigMode.addCommandSequence( 'IgmpHostProxy.intf', \
      after=[ 'Ira.ipIntf' ])

def saveIntfConfig( igmpHostProxyIntfConfig, root, sysdbRoot, \
                    saveAll, saveAllDetail ):
   intf = igmpHostProxyIntfConfig
   mode = root[ IntfCliSave.IntfConfigMode ].getOrCreateModeInstance( intf.intfId )
   cmds = mode[ 'IgmpHostProxy.intf' ]
   starSource = '0.0.0.0'

   if intf.defaultHostProxy:
      cmds.addCommand( "ip igmp host-proxy" )

   if intf.groupSourceList or intf.aclList or intf.deletedGroupSourceList:   
      if intf.groupSourceList:
         for group, groupSource in intf.groupSourceList.items():
            if groupSource.includeSourceList:
               for incSource in groupSource.includeSourceList:
                  cmd = "ip igmp host-proxy %s include %s" % ( group, incSource )
                  cmds.addCommand( cmd )
            if groupSource.excludeSourceList:
               for excSource in groupSource.excludeSourceList:
                  if ( excSource != '0.0.0.0' ):
                     cmd = "ip igmp host-proxy %s exclude %s" % ( group, excSource )
                     cmds.addCommand( cmd )
                  else:
                     cmd = "ip igmp host-proxy %s" % group
                     cmds.addCommand( cmd )
            if not groupSource.includeSourceList and not \
                  groupSource.excludeSourceList:
               cmd = "ip igmp host-proxy %s" % group
               cmds.addCommand( cmd )
   
      if intf.aclList:
         for aclName in intf.aclList:
            cmd = "ip igmp host-proxy access-list %s" % aclName
            cmds.addCommand( cmd )

      if intf.deletedGroupSourceList:
         for group, groupSource in intf.deletedGroupSourceList.items():
            if starSource in groupSource.excludeSourceList:
               cmd = "no ip igmp host-proxy %s" % group
               cmds.addCommand( cmd )
               continue
            if groupSource.includeSourceList:
               for incSource in groupSource.includeSourceList:
                  cmd = "no ip igmp host-proxy %s include %s" % ( group, incSource )
                  cmds.addCommand( cmd )
            if groupSource.excludeSourceList:
               for excSource in groupSource.excludeSourceList:
                  if ( excSource != '0.0.0.0' ):
                     cmd = "no ip igmp host-proxy %s exclude %s" % \
                           ( group, excSource )
                     cmds.addCommand( cmd )

   if ( intf.unsolicitedReportIntvl.val != \
         intf.unsolicitedReportIntvl.defaultValue ):
      cmds.addCommand( ( 'ip igmp host-proxy report-interval %d' %
         ( intf.unsolicitedReportIntvl.val ) ) )
   elif saveAll:
      cmds.addCommand( ( 'no ip igmp host-proxy report-interval' ) )

   if ( intf.igmpVersion.val != intf.igmpVersion.defaultValue ):
      cmds.addCommand( ( 'ip igmp host-proxy version %s' %
         ( intf.igmpVersion.val ) ) )
   elif saveAll:
      cmds.addCommand( ( 'no ip igmp host-proxy version' ) )

@CliSave.saver( 'IgmpHostProxy::Config', 'igmphostproxy/config',
                requireMounts = ( 'routing/hardware/status',
                                  'interface/config/all',
                                  'interface/status/all' ) )
def saveConfig( igmpHostProxyConfig, root, sysdbRoot, options,
                requireMounts ):
   saveAll = options.saveAll
   saveAllDetail = options.saveAllDetail

   # Save the default config only if the platform supports multicast routing
   if not mcastRoutingSupported( sysdbRoot,
         requireMounts[ 'routing/hardware/status' ] ):
      saveAll = False
      saveAllDetail = False

   if saveAllDetail:
      cfgIntfNames = allRoutingProtocolIntfNames( sysdbRoot, includeEligible=True,
                                                  requireMounts=requireMounts )
   elif saveAll:
      # Routing configuration is allowed on switchports as well. 
      # Save configuration on all routing protocol interfaces and switchports
      # with non-default config.
      cfgIntfNames = set(
            allRoutingProtocolIntfNames( sysdbRoot, requireMounts=requireMounts ) +
            igmpHostProxyConfig.intfConfig.keys() )
   else:
      cfgIntfNames = igmpHostProxyConfig.intfConfig
    
   for intfName in cfgIntfNames:
      intfConfig = igmpHostProxyConfig.intfConfig.get( intfName )
      if not intfConfig:
         if saveAll:
            intfConfig = \
                  Tac.newInstance( 'IgmpHostProxy::IntfConfig', \
                  intfName )
            mode = root[ IntfCliSave.IntfConfigMode ].getOrCreateModeInstance( \
                  intfConfig.intfId )
            cmds = mode[ 'IgmpHostProxy.intf' ]

            cmds.addCommand( 'no ip igmp host-proxy' )
      else:
         saveIntfConfig( intfConfig, root, sysdbRoot, saveAll, saveAllDetail )
