# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, CliSave

from CliSavePlugin.Controllerdb import ( CvxConfigMode,
                                         controllerConfigPath,
                                         getClusterName )
from CliMode.Hsc import HscMode
from HscCliLib import ovsdbLogTypes

#------------------------------------------------------------------------------
# HSC Mode Saver
#------------------------------------------------------------------------------

class HscConfigSaveMode( HscMode, CliSave.Mode ):
   def __init__( self, param ):
      HscMode.__init__( self )
      CliSave.Mode.__init__( self, param )

CvxConfigMode.addChildMode( HscConfigSaveMode,
                            after=[ 'cvx' ] )

HscConfigSaveMode.addCommandSequence( 'hsc.config' )

#------------------------------------------------------------------------------
# Entity Saver
#------------------------------------------------------------------------------

defaults = Tac.Value( 'Hsc::CliDefaults' )

# pylint: disable-msg=C0322
@CliSave.saver( 'Hsc::CliConfig', 'hsc/cliconfig',
                requireMounts=( controllerConfigPath, ) )
def saveHscConfig( entity, root, sysdbRoot, options, requireMounts ):
   cmds = [ ]

   if entity.enableAgent or options.saveAll:
      cmds.append( "%sshutdown" % ( entity.enableAgent and "no " or "" ) )

   if entity.enableOvsdb and options.saveAll:
      cmds.append( 'no ovsdb-shutdown' )
   elif not entity.enableOvsdb:
      cmds.append( 'ovsdb-shutdown' )

   if entity.enableErrorReporting == defaults.enableErrorReporting \
         and options.saveAll:
      cmds.append( 'no error-reporting' )
   elif entity.enableErrorReporting != defaults.enableErrorReporting:
      cmds.append( 'error-reporting' )

   if entity.vtepListType == defaults.vtepListType and options.saveAll:
      cmds.append( 'vtep flood list type any' )
   elif entity.vtepListType != defaults.vtepListType:
      cmds.append( 'vtep flood list type all' )

   if entity.routingModeType == defaults.routingModeType and options.saveAll:
      cmds.append( 'routing direct' )
   elif entity.routingModeType != defaults.routingModeType:
      cmds.append( 'routing indirect' )

   if not entity.sslProfile and options.saveAll:
      cmds.append( 'no ssl profile' )
   elif entity.sslProfile:
      cmds.append( 'ssl profile ' + entity.sslProfile )

   for target in entity.managerAddress.keys():
      ipAddr = target.split( ':' )[ 1 ]
      port = target.split( ':' )[ 2 ]
      cmd = 'manager %s' % ( ipAddr, )
      if options.saveAll or int( port ) != defaults.managerPort:
         cmd += ' %s' % ( port )
      cmds.append( cmd )

   if entity.passiveTcpPort != defaults.passiveTcpPort:
      cmds.append( 'passive tcp port %s' % entity.passiveTcpPort )
      
   if not entity.persistDatabase:
      cmds.append( 'no persist-database' )
   elif options.saveAll:
      cmds.append( 'persist-database' )

   for key, val in ovsdbLogTypes.iteritems():
      setting = val.getSet( entity, None )

      if setting == val.default and not options.saveAll:
         continue

      cmds.append( key + ' ' + setting )

   if cmds:
      clusterName = getClusterName( requireMounts[ controllerConfigPath ] )
      cvxMode = root[ CvxConfigMode ].getOrCreateModeInstance(
         CvxConfigMode.modeName( clusterName ) )
      hscMode = cvxMode[ HscConfigSaveMode ].getOrCreateModeInstance( 'cvx-hsc' )
      cmdSeq = hscMode[ 'hsc.config' ]

      for cmd in cmds:
         cmdSeq.addCommand( cmd )
