# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from IntfCliSave import IntfConfigMode

IntfConfigMode.addCommandSequence( "HealthIndicator.intf" )

@CliSave.saver( "Hercules::HealthIndicatorConfigDir",
   "openconfig/config/healthIndicator" )

def saveHealthIndicatorConfig( entity, root, sysdbRoot, options ):
   for intf in entity.intfConfig.keys():
      mode = root[ IntfConfigMode ].getOrCreateModeInstance( intf )
      cmds = mode[ "HealthIndicator.intf" ]
      indicator = entity.intfConfig[ intf ].indicator
      if indicator == "healthIndicatorGood":
         cmds.addCommand( "health indicator good" )
      elif indicator == "healthIndicatorBad":
         cmds.addCommand( "health indicator bad" )
