# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliMode.HardwareLed import HardwareLedMode

SAVE_NAME = 'NorCalSys.hardwareLed'

class LedSaveMode( HardwareLedMode, CliSave.Mode ):
   def __init__( self, param ):
      HardwareLedMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

CliSave.GlobalConfigMode.addChildMode( LedSaveMode )
LedSaveMode.addCommandSequence( SAVE_NAME )

def getCommandColor( led ):
   if led.green == True:
      return 'green'
   elif led.red == True:
      return 'red'
   elif led.yellow == True:
      return 'yellow'
   elif led.blue == True:
      return 'blue'
   else:
      return 'off'

@CliSave.saver( 'Tac::Dir', 'led/config',
                requireMounts=( 'hardware/led/configInit', 'hardware/entmib', ) )
def saveLedCliConfig( entity, root, sysdbRoot, options, requireMounts ):
   for ledSet in entity:
      if ledSet == 'HardwareLedCliSet' and entity[ ledSet ].led:
         mode = root[ LedSaveMode ].getOrCreateModeInstance( SAVE_NAME )
         cmds = mode[ SAVE_NAME ]
         for name, led in entity[ ledSet ].led.iteritems():
            color = getCommandColor( led )
            if name.startswith( 'Fan' ):
               # Fan-tray commands
               cmds.addCommand( 'fan-tray %s color %s %s' % ( name, color, 'flashing'
                                                              if led.flashRate == 1
                                                              else '' ) )
            elif name.startswith( 'Power' ):
               # Power commands
               cmds.addCommand( 'power %s color %s %s' % ( name, color, 'flashing'
                                                           if led.flashRate == 1
                                                           else '' ) )
            elif name.startswith( 'Ethernet' ):
               # Interface commands
               cmds.addCommand( 'interface %s color %s %s' % ( name, color,
                                                               'flashing'
                                                               if led.flashRate == 1
                                                               else '' ) )
            else:
               # Otherwise we can still run the command with chassis
               cmds.addCommand( 'chassis %s color %s %s' % ( name, color, 'flashing'
                                                             if led.flashRate == 1
                                                             else '' ) )
         cmds.addCommand( 'exit' )
         return
