#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliMode.GribiMode import MgmtGribiMode, GribiTransportMode

class MgmtGribiSaveMode( MgmtGribiMode, CliSave.Mode ):
   def __init__( self, param ):
      MgmtGribiMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

class GribiTransportSaveMode( GribiTransportMode, CliSave.Mode ):
   def __init__( self, param ):
      GribiTransportMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

CliSave.GlobalConfigMode.addChildMode( MgmtGribiSaveMode )
MgmtGribiSaveMode.addCommandSequence( "Mgmt.gribi" )

MgmtGribiSaveMode.addChildMode( GribiTransportSaveMode )
GribiTransportSaveMode.addCommandSequence( "Mgmt.gribi.transport" )

@CliSave.saver( "Gribi::Config", "mgmt/gribi/config" )
def saveGribi( gribiConfig, root, sysdbRoot, options ):
   endpoint = gribiConfig.endpoint

   if endpoint is not None:
      parentMode = root[ MgmtGribiSaveMode ].getOrCreateModeInstance(
         "api-gribi" )
      mode = parentMode[ GribiTransportSaveMode ].getOrCreateModeInstance(
         endpoint.name )
      cmds = mode[ "Mgmt.gribi.transport" ]

      if not endpoint.enabled:
         cmds.addCommand( "shutdown" )
      elif options.saveAll:
         cmds.addCommand( "no shutdown" )

      if endpoint.port != endpoint.portDefault or options.saveAll:
         cmds.addCommand( "port %s" % endpoint.port )

      if endpoint.sslProfile != '':
         cmds.addCommand( "ssl profile %s" % endpoint.sslProfile )
      elif options.saveAll:
         cmds.addCommand( "no ssl profile" )
