# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave

CliSave.GlobalConfigMode.addCommandSequence( 'Interface.shutdownDelay' )

@CliSave.saver( 'Goodbye::Config::ConfigDir', 'goodbye/config' )
def saveGoodbyeConfig( entity, root, sysdbRoot, options ):
   cmds = root[ 'Interface.shutdownDelay' ]
   if entity.globalConfig is not None:
      cmds.addCommand( 'service interface shutdown delay %d' %
                       entity.globalConfig.delay )
   elif options.saveAll:
      cmds.addCommand( 'no service interface shutdown delay' )


