# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave, Tracing, AclLib
from AclCliSave import CpConfigMode
from CliSavePlugin.IraTcpCliSave import saveTcpMssConfig

__defaultTraceHandle__ = Tracing.Handle( 'AclCliSave' )

@CliSave.saver( 'Acl::Input::CpConfig', 'acl/cpconfig/cli',
                requireMounts = ( 'ip/vrf/config',
                   'acl/paramconfig' ) )
def saveCpConfig( entity, root, sysdbRoot, options,
                  requireMounts ):
   saveAll = options.saveAll
   paramConfig = requireMounts[ 'acl/paramconfig' ]
   allVrfConfig = requireMounts[ "ip/vrf/config" ]

   # collect all the VRFs and remove duplicates
   vrfNames = allVrfConfig.vrf.members()
   vrfNames.extend( entity.cpConfig[ 'ip' ].globalCpAcl.keys() )
   vrfNames.extend( entity.cpConfig[ 'ipv6' ].globalCpAcl.keys() )
   vrfNames.append( AclLib.defaultVrf )
   vrfNames = list( set( vrfNames ) )

   def saveCpAcl( aclType, mode ):
      for vrf in vrfNames:
         cpAclName = entity.cpConfig[ aclType ].globalCpAcl.get( vrf, 
                                                   paramConfig.cpAclNameDefault )
         if ( cpAclName != paramConfig.cpAclNameDefault ) or saveAll:
            # only create the mode if it has non-default configuration
            if mode is None:
               mode = root[ CpConfigMode ].getSingletonInstance()
            cmds = mode[ 'Acl.cp' ]
            if cpAclName:
               if ( vrf != AclLib.defaultVrf ):
                  cmds.addCommand( "%s access-group %s vrf %s in" %
                                                ( aclType, cpAclName, vrf ) )
               else:
                  cmds.addCommand( "%s access-group %s in" % ( aclType, cpAclName ) )
            else:
               if ( vrf != AclLib.defaultVrf ):
                  cmds.addCommand( "no %s access-group vrf %s in" %
                                                ( aclType, vrf ) )
               else:
                  cmds.addCommand( "no %s access-group in" % aclType )

   mode = None

   config4 = entity.cpConfig[ 'ip' ].tcpMssConfig
   config6 = entity.cpConfig[ 'ipv6' ].tcpMssConfig
   cmd = saveTcpMssConfig( saveAll, config4, config6 )
   if cmd is not None:
      # only create the mode if it's needed
      mode = root[ CpConfigMode ].getSingletonInstance()
      mode[ 'Acl.cp' ].addCommand( cmd )

   for aclType in ( 'ip', 'ipv6' ):
      saveCpAcl( aclType, mode )
