#!/usr/bin/env python
# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave, IntfCliSave

IntfCliSave.IntfConfigMode.addCommandSequence( 'FastServerFailover.intf' )

@CliSave.saver( 'FastServerFailover::Config', 'fastserverfailover/config' )
def saveFsfIntfConfig( entity, root, sysdbRoot, options ):
   for portConfig in entity.portConfig.values():
      intfId = portConfig.intfId
      mode = root[ IntfCliSave.IntfConfigMode ].getOrCreateModeInstance( intfId )
      intfCmds = mode[ 'FastServerFailover.intf' ]
      if portConfig.enabled:
         intfCmds.addCommand( 'monitor server-failure link' )
      elif options.saveAllDetail:
         intfCmds.addCommand( 'no monitor server-failure link' )
