#!/usr/bin/env python
# Copyright (c) 2009, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliMode.FsfMode import FsfMode

class FsfConfigMode( FsfMode, CliSave.Mode ):
   def __init__( self, param ):
      FsfMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

CliSave.GlobalConfigMode.addChildMode( FsfConfigMode )
FsfConfigMode.addCommandSequence( 'FastServerFailover.config' )

@CliSave.saver( 'FastServerFailover::Config', 'fastserverfailover/config' )
def saveFsfConfig( entity, root, sysdbRoot, options ):
   cmds = []

   for subnet in entity.subnet:
      cmds.append( 'network %s' % ( subnet ) )

   if entity.proxy:
      cmd = 'proxy'
      if entity.proxyLifetime != entity.proxyLifetimeDefault or \
         ( options.saveAll and entity.enabled ) or options.saveAllDetail:
         cmd += ' lifetime %d' % entity.proxyLifetime
      cmds.append( cmd )
   elif ( options.saveAll and entity.enabled ) or options.saveAllDetail:
      cmds.append( 'no proxy' )

   if entity.enabled:
      cmds.append( 'no shutdown' )
   elif options.saveAllDetail:
      cmds.append( 'shutdown' )

   if cmds:
      mode = root[ FsfConfigMode ].getOrCreateModeInstance( None )
      cmdSeq = mode[ 'FastServerFailover.config' ]
      for cmd in cmds:
         cmdSeq.addCommand( cmd )

