# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import CliSave
import Tac
from Toggles.FruToggleLib import toggleOverrideSystemMacEnabled

CliSave.GlobalConfigMode.addCommandSequence( 'SysMacAddress.config' )

EthAddr = Tac.Type( 'Arnet::EthAddr' )

@CliSave.saver( 'Fru::MacAddressConfig', 'sys/macAddress/config' )
def saveSystemMacAddress( sysMacAddrConfig, root, sysdbRoot, options ):
   if not toggleOverrideSystemMacEnabled():
      return

   cmds = root[ 'SysMacAddress.config' ]
   sysMacAddress = sysMacAddrConfig.macAddr
   if sysMacAddress != EthAddr.ethAddrZero:
      cmds.addCommand( 'system mac-address %s' % sysMacAddress)
   elif options.saveAll:
      cmds.addCommand( 'default system mac-address' )
