#!/usr/bin/env python
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
import Tac
import Tracing
from IntfCliSave import IntfConfigMode
from FlowspecCliLib import flowspecCapable, getFlowspecCmdFrom

t0 = Tracing.trace0

#----------------------------------------------------------------------------
# Returns the list of interface names which support flowspec.
#----------------------------------------------------------------------------
def allFlowspecIntfNames( sysdbRoot, requireMounts ):
   assert requireMounts
   intfConfigDir = requireMounts[ 'interface/config/all' ]
   return [ intfName for intfName in intfConfigDir
            if flowspecCapable( intfName ) ]

#----------------------------------------------------------------------------
# CliSave saver to convert flowspec/cliConfig and produce the running-config
#----------------------------------------------------------------------------
IntfConfigMode.addCommandSequence( 'Flowspec.intf' )

@CliSave.saver( 'Flowspec::CliConfig', 'flowspec/cliConfig',
                requireMounts=( 'interface/config/all', ) )
def saveFlowspecConfig( flowspecConfig, root, sysdbRoot, options, requireMounts ):
   configuredIntf = []
   t0( "saveAll", options.saveAll, "saveAllDetail", options.saveAllDetail )
   if options.saveAll:
      configuredIntf = allFlowspecIntfNames( sysdbRoot, requireMounts )
   else:
      configuredIntf = flowspecConfig.enabledIntf.keys()
   for intf in configuredIntf:
      intfMode = root[ IntfConfigMode ].getOrCreateModeInstance( intf )
      cmds = intfMode[ 'Flowspec.intf' ]
      ipVersion = flowspecConfig.enabledIntf.get( intf )
      if ipVersion is None:
         ipVersion = Tac.Value( 'Flowspec::IpVersion' )
      command = getFlowspecCmdFrom( ipVersion )
      if options.saveAll or ipVersion:
         cmds.addCommand( command )
