# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tracing
import CliSave
from IntfCliSave import IntfConfigMode
from CliMode.FlowTracking import FlowTrackingModeBase
from FlowTrackerCliUtil import (
      ftrTypeKwStr,
      ftrTypeInbandTelemetry,
      showFlowTracking,
      showFlowTrackingTrailer
)
import EthIntfUtil
import Toggles.InbandTelemetryCommonToggleLib

traceHandle = Tracing.Handle( 'FlowTrackingCliSave' )
t0 = traceHandle.trace0
t1 = traceHandle.trace1
t2 = traceHandle.trace2

#---------------------------------------------------------------------------------
# Cli savers
#---------------------------------------------------------------------------------

class FlowTrackingCliSaveMode( FlowTrackingModeBase, CliSave.Mode ):
   def __init__( self, param ):
      t0( 'FlowTrackingCliSaveMode:', param )
      FlowTrackingModeBase.__init__( self, param )
      CliSave.Mode.__init__( self, param )

   def skipIfEmpty( self ):
      return True

# Used to generate a block of flow tracking global level config commands.

CliSave.GlobalConfigMode.addChildMode( FlowTrackingCliSaveMode,
                              before=[ IntfConfigMode ] )
FlowTrackingCliSaveMode.addCommandSequence( 'FlowTracking.global' )
FlowTrackingCliSaveMode.addCommandSequence( 'FlowTracking.trailer',
                              after=[ 'FlowTracking.global' ] )
IntfConfigMode.addCommandSequence( 'FlowTracker.config' )

@CliSave.saver( 'FlowTracking::Config', 'flowtracking/config/sampled',
                requireMounts=( 'bridging/config', ) )
@CliSave.saver( 'FlowTracking::Config', 'flowtracking/config/hardware',
                requireMounts=( 'bridging/config', ) )
@CliSave.saver( 'FlowTracking::Config', 'flowtracking/config/inbandTelemetry',
                requireMounts=( 'bridging/config', ) )
def saveFlowTrackingGlobalConfig( entity, root, sysdbRoot, options, requireMounts ):
   if entity.name == "inbandTelemetry":
      if not Toggles.InbandTelemetryCommonToggleLib. \
            toggleFeatureInbandTelemetryEnabled():
         return
   saveAll = options.saveAll
   saveAllDetail = options.saveAllDetail
   lines = showFlowTracking( config=entity, ftrType=entity.name, cliSave=True,
                             saveAll=saveAll, saveAllDetail=saveAllDetail )

   if lines is not None:
      mode = root[ FlowTrackingCliSaveMode ].getOrCreateModeInstance(
                                                      ftrTypeKwStr[ entity.name ] )
      cmds = mode[ 'FlowTracking.global' ]
      t0( 'saveFlowTrackingGlobalConfig:', entity, root, sysdbRoot, options )
      for cmd in lines:
         cmds.addCommand( cmd )

   # interface flow tracker config
   if saveAll or saveAllDetail:
      bridgingConfig = requireMounts[ 'bridging/config' ]
      cfgIntfNames = EthIntfUtil.allSwitchportNames( bridgingConfig,
                                                     includeEligible=True )
   else:
      cfgIntfNames = entity.flowTrackerIntfConfig.keys()

   t1( "cfgIntfNames", cfgIntfNames )
   for intfName in cfgIntfNames:
      ftrIntf = entity.flowTrackerIntfConfig.get( intfName )
      if entity.name == ftrTypeInbandTelemetry:
         continue
      if ftrIntf:
         cmd = "flow tracker %s %s" % ( ftrTypeKwStr[ entity.name ],
                                        ftrIntf.trackerName )
      else:
         cmd = "no flow tracker %s" %  ftrTypeKwStr[ entity.name ]

      mode = root[ IntfConfigMode ].getOrCreateModeInstance( intfName )
      intfCmds = mode[ 'FlowTracker.config' ]
      intfCmds.addCommand( cmd )

@CliSave.saver( 'FlowTracking::Config', 'flowtracking/config/sampled' )
@CliSave.saver( 'FlowTracking::Config', 'flowtracking/config/hardware' )
@CliSave.saver( 'FlowTracking::Config', 'flowtracking/config/inbandTelemetry' )
@CliSave.saver( 'FlowTracking::Config', 'flowtracking/config/mirrorOnDrop' )
def saveFlowTrackingGlobalConfigTrailer( entity, root, sysdbRoot, options ):
   if entity.name == "inbandTelemetry":
      if not Toggles.InbandTelemetryCommonToggleLib. \
            toggleFeatureInbandTelemetryEnabled():
         return
   saveAll = options.saveAll
   saveAllDetail = options.saveAllDetail
   lines = showFlowTrackingTrailer( config=entity, ftrType=entity.name, cliSave=True,
                             saveAll=saveAll, saveAllDetail=saveAllDetail )

   if lines is not None:
      mode = root[ FlowTrackingCliSaveMode ].getOrCreateModeInstance(
                                                      ftrTypeKwStr[ entity.name ] )
      cmds = mode[ 'FlowTracking.trailer' ]
      t0( 'saveFlowTrackingGlobalConfigTrailer:', entity, root, sysdbRoot, options )
      for cmd in lines:
         cmds.addCommand( cmd )
