#!/usr/bin/env python
# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import CliSave

LINK_FAILURE_THRESHOLD_DEFAULT = 80

CliSave.GlobalConfigMode.addCommandSequence( 'Fabric.globalConfig' )

@CliSave.saver( 'Fabric::Config', 'hardware/fabric/fabricGlobalConfig' )
def saveFabricConfig( entity, root, sysdbRoot, options ):
   saveAll = options.saveAll
   saveAllDetail = options.saveAllDetail
   cmds = root[ 'Fabric.globalConfig' ]
   if entity.linkFailureActionIgnore:
      cmds.addCommand( 'no switch fabric insufficient-bandwidth action' )
   elif entity.linkFailureThresholdPercent != LINK_FAILURE_THRESHOLD_DEFAULT:
      cmds.addCommand( 'switch fabric insufficient-bandwidth action '
                       'linecard-shutdown threshold %d' % 
                       entity.linkFailureThresholdPercent )
   elif saveAll or saveAllDetail:
      cmds.addCommand( 'default switch fabric insufficient-bandwidth action' )
