# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.


import CliSave
import Url

CliSave.GlobalConfigMode.addCommandSequence( 'EventMon.global' )

@CliSave.saver( 'EventMon::Config', 'eventMon/config' )
def saveEventMonConfig( cfg, root, sysdbRoot, options ):
   cmds = root[ 'EventMon.global' ]
   saveAll = options.saveAll

   if cfg.agentEnabled != cfg.defaultAgentEnabled:
      noToken = '' if cfg.agentEnabled else 'no '
      cmds.addCommand( noToken + 'event-monitor' )
   elif saveAll:
      cmds.addCommand( 'default event-monitor' )

   for tableName, tableConfig in cfg.table.iteritems():
      if tableConfig.enabled != tableConfig.defaultEnabled or saveAll:
         noToken = '' if tableConfig.enabled else 'no '
         cmds.addCommand( noToken + 'event-monitor %s' % tableName )

   if ( cfg.foreverLogFileName != cfg.defaultForeverLogFileName or
        cfg.foreverLogDirectory != cfg.defaultForeverLogDirectory ):
      baseFilePath = "%s/%s" % ( cfg.foreverLogDirectory, cfg.foreverLogFileName )
      cmds.addCommand( 'event-monitor backup path %s' \
                       % Url.filenameToUrl( baseFilePath ) )
   elif saveAll:
      cmds.addCommand( 'no event-monitor backup path' )

   for tableName, tableConfig in cfg.table.iteritems():
      if tableConfig.foreverLogOverride:
         baseFilePath = "%s/%s" % ( tableConfig.foreverLogDirectory,
                                    tableConfig.foreverLogFileName )
         cmds.addCommand( 'event-monitor %s backup path %s' \
                   % ( tableName, Url.filenameToUrl( baseFilePath ) ) )
      elif saveAll:
         cmds.addCommand( 'no event-monitor %s backup path' % tableName )

   if cfg.foreverLogMaxSize.val != cfg.foreverLogMaxSize.defaultVal or saveAll:
      cmds.addCommand( 'event-monitor backup max-size %d' \
                        % cfg.foreverLogMaxSize.val )

   if cfg.bufferSize.val != cfg.bufferSize.defaultVal or saveAll:
      cmds.addCommand( 'event-monitor buffer max-size %d' \
                        % cfg.bufferSize.val )
