#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from Toggles import EtbaDutToggleLib

if EtbaDutToggleLib.toggleFastEtbaEnabled():
   CliSave.GlobalConfigMode.addCommandSequence( 'Etba.cli' )

   @CliSave.saver( 'Bridging::Etba::CliConfig', 'bridging/etba/cli/config' )
   def saveEtbaCliConfig( etbaCliConfig, root, sysdbRoot, options ):
      cmds = root[ 'Etba.cli' ]
      for fName, expression in etbaCliConfig.qtraceFilter.items():
         cmds.addCommand( 'platform tfa qtrace packet filter %s %s' %
                          ( fName, expression ) )
