# Copyright (c) 2006, 2007, 2008, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

#-------------------------------------------------------------------------------
# This module implements CliSave for the Errdisable commands
#-------------------------------------------------------------------------------
import CliSave, Tracing
import ErrdisableCliLib
from ErrdisableCliLib import causeNameWithoutSliceId

traceDetail = Tracing.trace2

CliSave.GlobalConfigMode.addCommandSequence( 'Errdisable' )


@CliSave.saver( 'Errdisable::Config', 'interface/errdisable/config',
                requireMounts = ( 'interface/errdisable/causegroup', ) )
def saveErrdisableConfig( entity, root, sysdbRoot, options,
                          requireMounts ):
   cmds = root[ 'Errdisable' ]
   causeGroupDir = requireMounts[ "interface/errdisable/causegroup" ]
   detectCauses = set( [ ] )
   recoveryCauses = set( [ ] )
   saveAll = options.saveAll

   if saveAll:
      # Get the detect and recovery causes.
      for causeGroup in ErrdisableCliLib.getCauseGroups( causeGroupDir ):
         strippedName = causeNameWithoutSliceId( causeGroup )
         if not causeGroupDir[ causeGroup ].hiddenCause and \
            causeGroupDir[ causeGroup ].installCauseEnableCliCmd:
            detectCauses.add( strippedName )

         if not causeGroupDir[ causeGroup ].hiddenCause and \
            causeGroupDir[ causeGroup ].installCauseRecoveryCliCmd:
            recoveryCauses.add( strippedName )
   else:
      detectCauses = set( entity.disabled )
      recoveryCauses = set( entity.timerRecoveryEnabled )
 
   #
   # 'errdisable detect cause ...' command
   # By default the cause detection is enabled, so generate the 'no'
   # version of the detect cause for the cause that are disabled.
   #
   for cause in sorted( detectCauses ):
      if cause in entity.disabled:
         if cause == 'link-flap':
            cause = 'link-change'
         cmds.addCommand( 'no errdisable detect cause %s' % cause )
      else:
         if cause == 'link-flap':
            cause = 'link-change'
         cmds.addCommand( 'errdisable detect cause %s' % cause )

   #
   # 'errdisable recovery cause ...' command
   #
   for cause in sorted( recoveryCauses ):
      if cause in entity.timerRecoveryEnabled:
         cmds.addCommand( 'errdisable recovery cause %s' % cause )
      else:
         cmds.addCommand( 'no errdisable recovery cause %s' % cause )

   if entity.recoveryInterval != entity.defaultRecoveryInterval or saveAll:
      cmds.addCommand( 'errdisable recovery interval %d' % entity.recoveryInterval )

