# Copyright (c) 2009, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import socket, CliSave, EosVersion

def writeHeader( param, cliModel=None ):
   vi = EosVersion.VersionInfo( param.sysdbRoot )
   where = socket.gethostname()
   header = "! device: %s (%s, EOS-%s)\n!\n" % (
         where,
         vi.modelName() or "unknown-hardware",
         vi.version() or "unknown-version" )

   if cliModel:
      cliModel.header.append( header )
   else:
      param.stream.write( header )

CliSave.GlobalConfigMode.addHeaderHook( writeHeader )
