#!/usr/bin/env python
# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, Tracing, CliSave
import IntfCliSave, EthIntfUtil
from CliMode.Eoam import EoamProfileModeBase, LinkMonitoringModeBase
from CliMode.Eoam import EoamConfigModeBase
from EoamTypes import tacEoamAction
from EoamTypes import errorTypeToEnumMap, enumToActionMap, enumToIntervalMap
t0 = Tracing.trace0

CliSave.GlobalConfigMode.addCommandSequence( 'Eoam.config' )
IntfCliSave.IntfConfigMode.addCommandSequence( 'Eoam.config' )

class EoamConfigMode( EoamConfigModeBase, CliSave.Mode ):
   def __init__( self, param ):
      EoamConfigModeBase.__init__( self )
      CliSave.Mode.__init__( self, self.longModeKey )

class EoamProfileConfigMode( EoamProfileModeBase, CliSave.Mode ):
   def __init__( self, param ):
      EoamProfileModeBase.__init__( self, param )
      CliSave.Mode.__init__( self, self.longModeKey )

class LinkMonitoringConfigMode( LinkMonitoringModeBase, CliSave.Mode ):
   def __init__( self, param ):
      LinkMonitoringModeBase.__init__( self, param )
      CliSave.Mode.__init__( self, self.longModeKey )

CliSave.GlobalConfigMode.addChildMode( EoamConfigMode )
EoamConfigMode.addChildMode( EoamProfileConfigMode )
EoamProfileConfigMode.addCommandSequence( 'Eoam.profile' )
EoamProfileConfigMode.addChildMode( LinkMonitoringConfigMode,
                                    after=[ 'Eoam.profile' ] )
LinkMonitoringConfigMode.addCommandSequence( 'EoamProfile.linkMonitoring' )

@CliSave.saver( 'Eoam::Config', 'eoam/config',
                requireMounts= ( 'interface/config/eth/phy/all',
                              ) )
def saveConfig( entity, root, sysdbRoot, options, requireMounts ):
   cmds = root[ 'Eoam.config' ]

   saveAll = options.saveAll
   if saveAll:
      phyIntfConfig = requireMounts[ 'interface/config/eth/phy/all' ]
      phyIntfNames = EthIntfUtil.allPhyEthernetInterfaceNames( phyIntfConfig )
      cfgIntfNames = \
          set( phyIntfNames + entity.intfToProfileName.keys() )
   else:
      cfgIntfNames = entity.intfToProfileName.keys()

   intfToProfileName = entity.intfToProfileName

   def getAppliedEoamProfileName( intfName ):
      # Only one eoamProfile will be active at a time
      # Get that from intfToProfileName
      intToProfileMap = entity.intfToProfileName
      if intfName in intToProfileMap:
         return intToProfileMap[ intfName ]
      return None

   for intfName in cfgIntfNames:
      if intfName in intfToProfileName:
         eoamProfileName = getAppliedEoamProfileName( intfName )
         intfMode = root[ IntfCliSave.IntfConfigMode ].getOrCreateModeInstance(
            intfName )
         cmds = intfMode[ 'Eoam.config' ]
         if eoamProfileName:
            cmds.addCommand( 'monitor ethernet oam profile %s' % (
               eoamProfileName ) )

   def addCommandEoamProfile( profileName ):
      eoamConfigMode = root[ EoamConfigMode ].getOrCreateModeInstance( None )
      eoamProfileMode = eoamConfigMode[ EoamProfileConfigMode ].\
                        getOrCreateModeInstance( profileName )
      eoamProfileConfig = entity.eoamProfile
      eoamProfile = eoamProfileConfig[ profileName ]
      cmdList = []
      if eoamProfile:
         if eoamProfile.recoveryTimeoutSecs:
            cmdList.append( "recovery-time %s" % eoamProfile.recoveryTimeoutSecs )
         elif saveAll:
            cmdList.append( "default recovery-time" )
         for errorType in [ 'fcs', 'symbol' ]:
            linkMonitorConfig = eoamProfile.linkMonitorConfig.get(
               errorTypeToEnumMap[ errorType ] )
            if linkMonitorConfig and linkMonitorConfig.threshold:
               cmdList.append( "%s threshold %s" % ( errorType,
                            linkMonitorConfig.threshold ) )
            elif saveAll:
               cmdList.append( "%s threshold 100" % errorType )
            if linkMonitorConfig and linkMonitorConfig.action != \
               tacEoamAction.actionLog:
               cmdList.append( "%s action %s" % ( errorType,
                            enumToActionMap[ linkMonitorConfig.action ] ) )
            elif saveAll:
               cmdList.append( "%s action log" % errorType )
            if linkMonitorConfig and linkMonitorConfig.period.val:
               cmdList.append( "%s period %s %s" % ( errorType,
                            linkMonitorConfig.period.val,
                            enumToIntervalMap[ linkMonitorConfig.period.unit ] ) )
            elif saveAll:
               cmdList.append( "%s period 10 sec " % errorType )

         if len( cmdList ) > 0:
            mode = eoamProfileMode[ LinkMonitoringConfigMode ].\
                   getOrCreateModeInstance( ( profileName ) )
            cmdSeq = mode[ 'EoamProfile.linkMonitoring' ]
            for cmd in cmdList:
               cmdSeq.addCommand( cmd )

   eoamProfileConfig = entity.eoamProfile
   for profileConfig in sorted( eoamProfileConfig ):
      addCommandEoamProfile( eoamProfileConfig[ profileConfig ].profileName )

