# Copyright (c) 2008, 2009, 2010, 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave

CliSave.GlobalConfigMode.addCommandSequence( 'Thermostat.config' )

@CliSave.saver( 'Environment::Thermostat::Config', 'environment/thermostat/config' )
def saveThermostatConfig( entity, root, sysdbRoot, options ):
   cmds = root[ 'Thermostat.config' ]
   saveAll = options.saveAll
   if not entity.shutdownOnOverheat:
      cmds.addCommand( "environment overheat action ignore" )
   elif saveAll:
      cmds.addCommand( "environment overheat action shutdown" )
   if not entity.shutdownOnInsufficientFans:
      cmds.addCommand( "environment insufficient-fans action ignore" )
   elif saveAll:
      cmds.addCommand( "environment insufficient-fans action shutdown" )
   if entity.mode == 'manual' and entity.fanSpeed:
      cmds.addCommand( "environment fan-speed override %s" % int( entity.fanSpeed ) )
   elif saveAll:
      cmds.addCommand( "environment fan-speed auto" )
   if entity.ignoreInvalidTemp:
      cmds.addCommand( "environment temperature invalid action ignore" )
   elif saveAll:
      cmds.addCommand( "no environment temperature invalid action ignore" )
   if entity.ignoreInvalidThirdPartyXcvrTemp:
      cmds.addCommand( "environment temperature transceiver third-party "
                       "invalid action ignore" )
   elif saveAll:
      cmds.addCommand( "no environment temperature transceiver third-party "
                       "invalid action ignore" )

