# Copyright (c) 2009, 2010, 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave, DesCrypt
from CliMode.Email import EmailMode

class EmailConfigMode( EmailMode, CliSave.Mode ):

   def __init__( self, param ):
      EmailMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

CliSave.GlobalConfigMode.addChildMode( EmailConfigMode )
EmailConfigMode.addCommandSequence( 'Email' )

@CliSave.saver( 'System::EmailConfig', 'sys/email/config' )
def saveEmail( emailConfig, root, sysdbRoot, options ):
   saveAll = options.saveAll
   # Only create the mode if there are any settings to save.
   if emailConfig.fromUser or emailConfig.host or emailConfig.port != 25 or \
        emailConfig.user or emailConfig.password or emailConfig.useTls or saveAll:
      mode = root[ EmailConfigMode ].getOrCreateModeInstance( 'email' )
      cmds = mode[ 'Email' ]
      if emailConfig.fromUser:
         cmds.addCommand( "from-user %s" % emailConfig.fromUser )
      elif saveAll:
         cmds.addCommand( "no from-user" )
      if emailConfig.host:
         cmd = "server "
         if emailConfig.vrfName != '':
            cmd += "vrf %s " % emailConfig.vrfName
         cmd += emailConfig.host
         if emailConfig.port != 25 or saveAll:
            cmd += ":%d" % emailConfig.port
         cmds.addCommand( cmd )
      elif saveAll:
         cmds.addCommand( "no server" )
      if emailConfig.user:
         cmds.addCommand( "auth username %s" % emailConfig.user )
      elif saveAll:
         cmds.addCommand( "no auth username" )
      if emailConfig.password:
         cmds.addCommand( "auth password 7 %s" % DesCrypt.encrypt(
                                        emailConfig.name + "_cryptkey_email",
                                        emailConfig.password ) )
      elif saveAll:
         cmds.addCommand( "no auth password" )
      if emailConfig.useTls:
         cmds.addCommand( "tls" )
      elif saveAll:
         cmds.addCommand( "no tls" )
