# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import Tac, CliSave, Tracing
from CliMode.DynamicPrefixList import DynamicPrefixListMode
from CliSave import GlobalConfigMode

__defaultTraceHandle__ = Tracing.Handle( 'DynamicPrefixList')
t5 = Tracing.trace5 # Info

class DynamicPrefixListCliSaveMode( DynamicPrefixListMode, CliSave.Mode ):
   def __init__( self, param ):
      DynamicPrefixListMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

DynamicPrefixListCliSaveMode.addCommandSequence( 'DynamicPrefixList.config' )
GlobalConfigMode.addChildMode( DynamicPrefixListCliSaveMode,
                               after=[ 'Ira.routeFilter' ] )

def saveDynamicPrefixConfig( dynPfx, cmds ):
   if dynPfx.matchMap:
      cmd = 'match-map %s' % dynPfx.matchMap
      cmds.addCommand( cmd )

   if dynPfx.ipv4PrefixList:
      cmd = 'prefix-list ipv4 %s' % dynPfx.ipv4PrefixList
      cmds.addCommand( cmd )

   if dynPfx.ipv6PrefixList:
      cmd = 'prefix-list ipv6 %s' % dynPfx.ipv6PrefixList
      cmds.addCommand( cmd )

@CliSave.saver( 'Routing::DynamicPrefixList::Config', 'routing/dynPfxList/config' )
def saveDynamicPrefixListConfig( entity, root, sysdbRoot, options ):
   if not len ( entity.dynamicPrefixList ):
      return

   for dynPfxName in entity.dynamicPrefixList:
      t5 ( ' Iterate over Dynamic Prefix List %s' % dynPfxName )
      mode = root[ DynamicPrefixListCliSaveMode
            ].getOrCreateModeInstance( ( dynPfxName ) )
      cmds = mode[ 'DynamicPrefixList.config' ]
      dynPfx = entity.dynamicPrefixList.get( dynPfxName )
      if dynPfx:
         saveDynamicPrefixConfig( dynPfx, cmds )
