# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import CliSave
from CliSavePlugin.RouterGeneralCliSave import getRouterGeneralVrfModeCtx
from CliSavePlugin.RouterGeneralCliSave import RouterGeneralVrfCliSaveMode

# pkgdeps: library DynPolicyRoutes
 
prefDefault = Tac.Type( "Routing::DynPolicyRoutes::Constants" ).preferenceDefault

RouterGeneralVrfCliSaveMode.addCommandSequence( 'routes.dynamic', 
                                                after=[ 'vrfConfig' ] )
def saveDynPolicyRoutesVrfConfig( vrfConfig, saveAll, cmds ):
   for dpl in sorted( vrfConfig.dynamicRoute ):
      drConfig = vrfConfig.dynamicRoute[ dpl ] 
      cmd = 'routes dynamic prefix-list %s' % dpl
      if drConfig.install:
         cmd += ' install'
      if drConfig.drop:
         cmd += ' drop'
      # preference is the only option that has a default value
      # so check for saveAll. preference is currently supported
      # only along with install so check for that as-well
      # Example: routes dynamic prefix-list x preference 30 
      # is invalid
      if drConfig.preference != prefDefault or \
         ( saveAll and drConfig.install ):
         cmd += ' preference %s' % drConfig.preference

      cmds.addCommand( cmd )


@CliSave.saver( 'Routing::DynPolicyRoutes::Config', 
                'routing/general/config/dynPolicyRoutes' )
def saveDynPolicyRoutesConfig( entity, root, sysdbRoot, options ):
   saveAll = options.saveAll
   if not len( entity.vrfConfig ):
      return

   for vrfName in sorted( entity.vrfConfig ):
      vrfConfig = entity.vrfConfig[ vrfName ]
      # Get reference to the 'vrf ...' mode
      vrfMode = getRouterGeneralVrfModeCtx( root, vrfName )
      cmds = vrfMode[ 'routes.dynamic' ]
      saveDynPolicyRoutesVrfConfig( vrfConfig, saveAll, cmds )
