# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave, Tracing, AclLib
from IntfCliSave import IntfConfigMode
from CliMode.DpAcl import HardwareAclPermitDuringUpdateMode
from CliMode.DpAcl import HardwareAclIngressSharingMode
from CliMode.DpAcl import HardwareAclEgressIp6SharingMode
from CliMode.DpAcl import HardwareAclEgressIpSharingOnMode
from CliMode.DpAcl import HardwareAclEgressIpSharingOffMode

__defaultTraceHandle__ = Tracing.Handle( 'AclCliSave' )

class HardwareAclActionDuringUpdatePermit( HardwareAclPermitDuringUpdateMode,
                                           CliSave.Mode ):
   def __init__( self, param ):
      HardwareAclPermitDuringUpdateMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

class HardwareAclActionDuringUpdateDeny( CliSave.Mode ):
   def enterCmd( self ):
      return 'no hardware access-list update default-result permit'

class HardwareAclActionDuringUpdateUnset( CliSave.Mode ):
   def enterCmd( self ):
      return 'default hardware access-list update default-result permit'

class HardwareAclIngressSharing( HardwareAclIngressSharingMode, CliSave.Mode ):
   def __init__( self, param ):
      HardwareAclIngressSharingMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

class HardwareAclEgressIp6Sharing( HardwareAclEgressIp6SharingMode, CliSave.Mode ):
   def __init__( self, param ):
      HardwareAclEgressIp6SharingMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

class HardwareAclEgressIpSharingOn( HardwareAclEgressIpSharingOnMode, CliSave.Mode ):
   def __init__( self, param ):
      HardwareAclEgressIpSharingOnMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

class HardwareAclEgressIpSharingOff( HardwareAclEgressIpSharingOffMode,
                                     CliSave.Mode ):
   def __init__( self, param ):
      HardwareAclEgressIpSharingOffMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

class HardwareRouterAclExcludeMlagPeerLink( CliSave.Mode ):
   def enterCmd( self ):
      return 'hardware access-list router-acl exclude mlag peer-link'

IntfConfigMode.addCommandSequence( 'Acl.intf', after=[ 'Lag.lagConfig' ] )

CliSave.GlobalConfigMode.addChildMode( HardwareAclActionDuringUpdatePermit,
                                       before=[ IntfConfigMode ] )
HardwareAclActionDuringUpdatePermit.addCommandSequence( 'Acl.knob' )

CliSave.GlobalConfigMode.addChildMode( HardwareAclActionDuringUpdateDeny,
                                       before=[ IntfConfigMode ] )
HardwareAclActionDuringUpdateDeny.addCommandSequence( 'Acl.knob' )

CliSave.GlobalConfigMode.addChildMode( HardwareAclActionDuringUpdateUnset,
                                       before=[ IntfConfigMode ] )
HardwareAclActionDuringUpdateUnset.addCommandSequence( 'Acl.knob' )

CliSave.GlobalConfigMode.addChildMode( HardwareAclIngressSharing,
                                       before=[ IntfConfigMode ] )
HardwareAclIngressSharing.addCommandSequence( 'Acl.ingressRaclSharing' )

CliSave.GlobalConfigMode.addChildMode( HardwareAclEgressIp6Sharing,
                                       before=[ IntfConfigMode ] )
HardwareAclEgressIp6Sharing.addCommandSequence( 'Acl.egressIp6RaclSharing' )

CliSave.GlobalConfigMode.addChildMode( HardwareAclEgressIpSharingOn,
                                       before=[ IntfConfigMode ] )
HardwareAclEgressIpSharingOn.addCommandSequence( 'Acl.egressIpRaclSharingOn' )

CliSave.GlobalConfigMode.addChildMode( HardwareAclEgressIpSharingOff,
                                       before=[ IntfConfigMode ] )
HardwareAclEgressIpSharingOff.addCommandSequence( 'Acl.egressIpRaclSharingOff' )

CliSave.GlobalConfigMode.addChildMode( HardwareRouterAclExcludeMlagPeerLink,
                                       before=[ IntfConfigMode ] )
HardwareRouterAclExcludeMlagPeerLink.addCommandSequence(
                                       'Acl.excludeMlagPeerLink' )

CliSave.GlobalConfigMode.addCommandSequence( 'Acl.deepInsp',
                                             before=[ IntfConfigMode ] )

CliSave.GlobalConfigMode.addCommandSequence( 'Acl.Ipv6Icmp6Match',
                                             before=[ IntfConfigMode ] )

CliSave.GlobalConfigMode.addCommandSequence( 'Acl.EgressRoutedInterfaceAclSharing',
                                             before=[ IntfConfigMode ] )

CliSave.GlobalConfigMode.addCommandSequence( 
      'Acl.ingressIpv4Ipv6SecurityAclSharingSupported', 
      before=[ IntfConfigMode ] )

CliSave.GlobalConfigMode.addCommandSequence( 
      'Acl.ingressIpv4Ipv6MirroringAclSharingSupported', 
      before=[ IntfConfigMode ] )

CliSave.GlobalConfigMode.addCommandSequence( 
      'Acl.ingressIpv4Ipv6QosAclSharingSupported', 
      before=[ IntfConfigMode ] )

CliSave.GlobalConfigMode.addCommandSequence( 
      'Acl.ingressIpv6SecurityAclKeyWidthMode', 
      before=[ IntfConfigMode ] )

CliSave.GlobalConfigMode.addCommandSequence( 
      'Acl.ingressIpv6QosAclKeyWidthMode', 
      before=[ IntfConfigMode ] )

CliSave.GlobalConfigMode.addCommandSequence( 
      'Acl.ingressMirrorAclKeyWidthMode', 
      before=[ IntfConfigMode ] )

@CliSave.saver( 'Acl::IntfConfig', 'acl/intf/config/cli',
                requireMounts=( 'acl/config/cli',
                                'acl/intf/config/input/secure-monitor' ),
                secureMonitor=True )
def saveDpConfig( entity, root, sysdbRoot, options, requireMounts ):
   allAclConfig = requireMounts[ 'acl/config/cli' ]
   if options.secureMonitor:
      entity = requireMounts[ 'acl/intf/config/input/secure-monitor' ]
   # per-interface ACL config
   for aclType in AclLib.aclTypes:
      typeConfig = entity.config[ aclType ]
      for direction in AclLib.aclDirections:
         config = typeConfig.intf[ direction ].intf
         for intfName, aclName in config.iteritems( ):
            aclConfType = allAclConfig.config.get( aclType )
            if aclConfType:
               aclConf = aclConfType.acl.get( aclName )
               if aclConf and aclConf.dynamic:
                  continue
            # only create the mode if it has non-default configuration
            mode = root[ IntfConfigMode ].getOrCreateModeInstance( intfName )
            cmds = mode[ 'Acl.intf' ]
            cmds.addCommand( "%s access-group %s %s" % (
               aclType.lower( ), aclName, direction ) )

@CliSave.saver( 'Acl::ParamConfig', 'acl/paramconfig',
                requireMounts=( 'acl/status/all', ) )
def saveAclKnobConfig( entity, root, sysdbRoot, options, requireMounts ):
   status = requireMounts[ 'acl/status/all' ]
   if entity.permitDuringAclUpdateConfig == \
      AclLib.ActionDuringAclUpdate.actionDuringAclUpdatePermit :
      # CLI value is permit
      if status.dpDefaultActionDuringAclUpdate == \
         AclLib.ActionDuringAclUpdate.actionDuringAclUpdatePermit :
         if options.saveAll:
            # default behaviour permit then only saveAll
            root[ HardwareAclActionDuringUpdatePermit ].getOrCreateModeInstance(
               entity.name )
      else:
         # default behaviour not permit
         root[ HardwareAclActionDuringUpdatePermit ].getOrCreateModeInstance(
            entity.name )
   elif entity.permitDuringAclUpdateConfig == \
        AclLib.ActionDuringAclUpdate.actionDuringAclUpdateDeny :
      # CLI value is deny
      if status.dpDefaultActionDuringAclUpdate == \
         AclLib.ActionDuringAclUpdate.actionDuringAclUpdateDeny :
         if options.saveAll:
            # default behaviour deny then only saveAll
            root[ HardwareAclActionDuringUpdateDeny ].getOrCreateModeInstance(
               entity.name )
      else:
         # default behaviour not deny
         root[ HardwareAclActionDuringUpdateDeny ].getOrCreateModeInstance(
            entity.name )
   elif ( ( entity.permitDuringAclUpdateConfig == \
          AclLib.ActionDuringAclUpdate.actionDuringAclUpdateUnset ) and \
          options.saveAll ) :
      # CLI value is unset
      if status.dpDefaultActionDuringAclUpdate == \
         AclLib.ActionDuringAclUpdate.actionDuringAclUpdateUnset :
         # default behaviour unset
         root[ HardwareAclActionDuringUpdateUnset ].getOrCreateModeInstance(
            entity.name )
      elif status.dpDefaultActionDuringAclUpdate == \
           AclLib.ActionDuringAclUpdate.actionDuringAclUpdateDeny :
         # default behaviour deny
         root[ HardwareAclActionDuringUpdateDeny ].getOrCreateModeInstance(
            entity.name )
      elif status.dpDefaultActionDuringAclUpdate == \
           AclLib.ActionDuringAclUpdate.actionDuringAclUpdatePermit :
         # default behaviour permit
         root[ HardwareAclActionDuringUpdatePermit ].getOrCreateModeInstance(
            entity.name )

@CliSave.saver( 'Acl::ParamConfig', 'acl/paramconfig' )
def saveIngressRaclSharingConfig( entity, root, sysdbRoot, options ):
   if entity.ingressRaclSharing:
      root[ HardwareAclIngressSharing ].getOrCreateModeInstance( entity.name )

@CliSave.saver( 'Acl::ParamConfig', 'acl/paramconfig' )
def saveEgressIp6RaclSharingConfig( entity, root, sysdbRoot, options ):
   if entity.egressIp6RaclSharing:
      root[ HardwareAclEgressIp6Sharing ].getOrCreateModeInstance( entity.name )

@CliSave.saver( 'Acl::ParamConfig', 'acl/paramconfig',
                requireMounts = ( 'acl/status/all', ) )
def saveEgressIpRaclSharingConfig( entity, root, sysdbRoot, options, requireMounts ):
   status = requireMounts[ 'acl/status/all' ]
   if not entity.egressIpRaclSharing:
      root[ HardwareAclEgressIpSharingOff ].getOrCreateModeInstance( entity.name )
   else:
      # Check for platform compatibility.
      if status.dpEgressRaclSharingSupported and options.saveAll:
         root[ HardwareAclEgressIpSharingOn ].getOrCreateModeInstance( entity.name )

@CliSave.saver( 'Acl::ParamConfig', 'acl/paramconfig' )
def saveExcludeMlagPeerLinkConfig( entity, root, sysdbRoot, options ):
   if entity.excludeMlagPeerLink:
      root[ HardwareRouterAclExcludeMlagPeerLink ].getOrCreateModeInstance(
                                                                     entity.name )

@CliSave.saver( 'Acl::ParamConfig', 'acl/paramconfig' )
def saveAclDeepInspConfig( entity, root, sysdbRoot, options ):
   if not entity.deepInspSkipL2 and not entity.deepInspSkipL4 and not \
          options.saveAll:
      return
   cmd = root[ 'Acl.deepInsp' ]
   if entity.deepInspSkipL2:
      cmd.addCommand( 'deep-inspection payload l2 skip %d' % entity.deepInspSkipL2 )
   elif options.saveAll:
      cmd.addCommand( 'no deep-inspection payload l2 skip' )
   if entity.deepInspSkipL4:
      cmd.addCommand( 'deep-inspection payload l4 skip %d' % entity.deepInspSkipL4 )
   elif options.saveAll:
      cmd.addCommand( 'no deep-inspection payload l4 skip' )

@CliSave.saver( 'Acl::ParamConfig', 'acl/paramconfig' )
def saveImplicitIcmp6RulesTypeConfig( entity, root, sysdbRoot, options ):
   cmd = root[ 'Acl.Ipv6Icmp6Match' ]
   if entity.permitIcmp6TypesConfig == AclLib.Icmp6RuleType.neighborDiscovery:
      cmd.addCommand( 'hardware access-list ipv6 implicit-permit icmpv6 ' + \
                         'neighbor-discovery' )
   elif options.saveAll:
      cmd.addCommand( 'hardware access-list ipv6 implicit-permit icmpv6 all' )

@CliSave.saver( 'Acl::ParamConfig', 'acl/paramconfig' )
def saveEgressRoutedInterfaceAclSharingConfig( entity, root, sysdbRoot, options ):
   cmd = root[ 'Acl.EgressRoutedInterfaceAclSharing' ]
   command = "hardware access-list ipv4 egress resource sharing routed-interfaces"
   if entity.egressRoutedInterfaceAclSharing:
      cmd.addCommand( command )
   elif options.saveAll:
      cmd.addCommand( "no " + command )

@CliSave.saver( 'Acl::ParamConfig', 'acl/paramconfig' )
def saveIngressIpv4Ipv6SecurityAclSharing( entity, root, sysdbRoot, options ):
   cmd = root[ 'Acl.ingressIpv4Ipv6SecurityAclSharingSupported' ]
   if entity.ingressIpv4Ipv6PaclSharingSupported:
      cmd.addCommand( 'hardware access-list resource sharing ipv4-ipv6 ' + \
                      'security-acl in' )
   elif options.saveAll:
      cmd.addCommand( 'no hardware access-list resource sharing ipv4-ipv6' + \
                      ' security-acl in' )

@CliSave.saver( 'Acl::ParamConfig', 'acl/paramconfig' )
def saveIngressIpv4Ipv6MirroringAclSharing( entity, root, sysdbRoot, 
                                            options ):
   cmd = root[ 'Acl.ingressIpv4Ipv6MirroringAclSharingSupported' ]
   if entity.ingressIpv4Ipv6MirrorAclSharingSupported:
      cmd.addCommand( 'hardware access-list resource sharing ipv4-ipv6 ' + \
                      'mirroring-policy in' )
   elif options.saveAll:
      cmd.addCommand( 'no hardware access-list resource sharing ipv4-ipv6' + \
                      ' mirroring-policy in' )

@CliSave.saver( 'Acl::ParamConfig', 'acl/paramconfig' )
def saveIngressIpv4Ipv6QosAclSharingMode( entity, root, sysdbRoot, 
                                          options ):
   cmd = root[ 'Acl.ingressIpv4Ipv6QosAclSharingSupported' ]
   if entity.ingressIpv4Ipv6QosAclSharingSupported:
      cmd.addCommand( 'hardware access-list resource sharing ipv4-ipv6 ' + \
                      'qos-policy in' )
   elif options.saveAll:
      cmd.addCommand( 'no hardware access-list resource sharing ipv4-ipv6' + \
                      ' qos-policy in' )

@CliSave.saver( 'Acl::ParamConfig', 'acl/paramconfig' )
def saveIngressMirroringAclKeyWidthMode( entity, root, sysdbRoot, 
                                       options ):
   cmd = root[ 'Acl.ingressMirrorAclKeyWidthMode' ]
   if entity.ingressMirrorAclKeyWidthMode == \
         AclLib.TcamBankSharingMode.bankSharingModeNarrow:
      cmd.addCommand( 'hardware access-list ipv4-ipv6 mirroring-policy ' + \
            'key-width narrow in' )
   elif options.saveAll:
      cmd.addCommand( 'no hardware access-list ipv4-ipv6 mirroring-policy ' + \
                      ' key-width in' )

@CliSave.saver( 'Acl::ParamConfig', 'acl/paramconfig' )
def saveIngressIpv6SecurityAclKeyWidthMode( entity, root, sysdbRoot, 
                                            options ):
   cmd = root[ 'Acl.ingressIpv6SecurityAclKeyWidthMode' ]
   if entity.ingressIpv6SecurityAclKeyWidthMode == \
         AclLib.TcamBankSharingMode.bankSharingModeNarrow:
      cmd.addCommand( 'hardware access-list ipv6 security-acl ' + \
            'key-width narrow in' )
   elif options.saveAll:
      cmd.addCommand( 'no hardware access-list ipv6 security-acl ' + \
                      ' key-width in' )

@CliSave.saver( 'Acl::ParamConfig', 'acl/paramconfig' )
def saveIngressIpv6QosAclKeyWidthMode( entity, root, sysdbRoot, 
                                       options ):
   cmd = root[ 'Acl.ingressIpv6QosAclKeyWidthMode' ]
   if entity.ingressIpv6QosAclKeyWidthMode == \
         AclLib.TcamBankSharingMode.bankSharingModeNarrow:
      cmd.addCommand( 'hardware access-list ipv6 qos-policy ' + \
            'key-width narrow in' )
   elif options.saveAll:
      cmd.addCommand( 'no hardware access-list ipv6 qos-policy ' + \
                      ' key-width in' )

