# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
import Tac, Tracing
from CliMode.Dot1x import Dot1xSuppProfileBaseMode
from IntfCliSave import IntfConfigMode
from Dot1xCliSave import Dot1xConfigMode

__defaultTraceHandle__ = Tracing.Handle( 'Dot1xSupplicantCliSave' )

CliSave.GlobalConfigMode.addCommandSequence( 'dot1x.global' )
IntfConfigMode.addCommandSequence( 'dot1x.intf' )

class Dot1xProfileConfigMode( Dot1xSuppProfileBaseMode, CliSave.Mode ):
   def __init__( self, param ):
      Dot1xSuppProfileBaseMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

Dot1xConfigMode.addChildMode( Dot1xProfileConfigMode )
Dot1xProfileConfigMode.addCommandSequence( 'dot1x.supp.profile' )

def saveProfileConfig( profile, root, config, sysdbRoot, options ):
   suppMode = root[ Dot1xConfigMode ].getOrCreateModeInstance( None )
   mode = suppMode[ Dot1xProfileConfigMode ].getOrCreateModeInstance( profile.name )
   cmds = mode[ 'dot1x.supp.profile' ]

   if profile.identity != "":
      cmds.addCommand( 'identity %s' % profile.identity )
   elif options.saveAll:
      cmds.addCommand( 'no identity' )

   if profile.eapMethod != profile.eapMethodDefault:
      cmds.addCommand( 'eap-method %s' % profile.eapMethod )
   elif options.saveAll:
      cmds.addCommand( 'no eap-method' )

   if profile.encryptedPassword != "":
      cmds.addCommand( 'passphrase 7 %s' % \
            CliSave.sanitizedOutput( options, "%s" % profile.encryptedPassword ) )
   elif options.saveAll:
      cmds.addCommand( 'no passphrase' )

def saveIntfConfig( intfConfig, root, config, sysdbRoot, saveAll ):
   mode = root[ IntfConfigMode ].getOrCreateModeInstance( intfConfig.intfId )
   cmds = mode[ 'dot1x.intf' ]

   cmds.addCommand( 'dot1x pae supplicant %s' % intfConfig.profileName )

@CliSave.saver( 'Dot1x::Config', 'dot1x/config' )
def saveDot1xSuppConfig( config, root, sysdbRoot, options ):
   saveAll = options.saveAll

   # Save supplicant profile config.
   for profileName in sorted( config.supplicantProfile ):
      saveProfileConfig( config.supplicantProfile[ profileName ], root, config,
            sysdbRoot, options )
   
   # Save supplicant interface config.
   for intfId in config.supplicantIntfConfig:
      saveIntfConfig( config.supplicantIntfConfig[ intfId ], root, config,
            sysdbRoot, saveAll )
