# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliMode.DecapGroup import DecapGroupBaseMode

class DecapGroupConfigSaveMode( DecapGroupBaseMode, CliSave.Mode ):
   def __init__( self, param ):
      self.saveOrder_ = 50
      DecapGroupBaseMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

CliSave.GlobalConfigMode.addCommandSequence( 'Tunnel.DecapGroups' )
CliSave.GlobalConfigMode.addChildMode( DecapGroupConfigSaveMode,
                                       after=[ 'Tunnel.DecapGroups' ] )
DecapGroupConfigSaveMode.addCommandSequence( 'DecapGroups.cfg' )

#switch(config)# ip decap-group type udp destination port 6080 payload ip
#switch(config)# ip decap-group foo
#switch(config-dg-foo)# tunnel type gre
#switch(config-dg-foo)# tunnel decap-ip 1.1.0.1

@CliSave.saver( 'Tunnel::Decap::ConfigInput', "routing/tunneldecap/input/cli" )
def saveDecapGroups ( entity, root, sysdbRoot, options ):
   cmds = root[ 'Tunnel.DecapGroups' ]
   for port, ptype in entity.globalDestPortToPayloadType.iteritems():
      ptype = 'ip' if ptype == 'ipvx' else ptype
      cmd = 'ip decap-group type udp destination port {} payload {}'.format(
               port, ptype )
      cmds.addCommand( cmd )

   for dgName in sorted( entity.decapGroup ):
      dg = entity.decapGroup[ dgName ]
      if dg.dynamic:
         continue
      mode = root[ DecapGroupConfigSaveMode ].getOrCreateModeInstance( dgName )
      cmdSeq = mode[ 'DecapGroups.cfg' ]

      if dg.tunnelType == 'gre':
         cmdSeq.addCommand( 'tunnel type gre' )

      elif dg.tunnelType == 'ipip':
         cmdSeq.addCommand( 'tunnel type ipip' )

      elif dg.tunnelType == 'udp':
         cmdSeq.addCommand( 'tunnel type udp' )
         if dg.destinationPort != 0:
            cmdSeq.addCommand( 'tunnel udp destination port ' + \
                               str( dg.destinationPort ) + \
                               ' payload ' + dg.payloadType )

      for each in sorted( dg.decapIp.keys() ):
         cmdSeq.addCommand( 'tunnel decap-ip ' + each.stringValue )
      
      for key in sorted( dg.decapIntf.keys() ):
         # get exclude interface option, if any
         excludeIntfOption = ''
         if key in dg.decapExcludeIntfSet:
            # only permit exclude interface option on decap-interface all
            assert key.intfId == ""
            excludeIntf = dg.decapExcludeIntfSet[ key ] .excludeIntf
            if excludeIntf:
               excludeIntfOption = ' exclude ' + \
                   ' '.join( [ str( intfId ) for intfId in excludeIntf ] )
         else:
            excludeIntfOption = ''

         if dg.decapIntf[ key ].oldConfig: 
            if key.intfId != "":
               cmdSeq.addCommand( 'tunnel decap-interface ' + 
                                  key.intfId )
            else:
               cmdSeq.addCommand( 'tunnel decap-interface all' + excludeIntfOption )
         else:
            if key.intfId != "":
               cmdSeq.addCommand( 
                  'tunnel decap-interface ' + key.intfId + \
                  ' address-family ' + key.addressFamily + \
                  ' address ' + dg.decapIntf[ key ].addressType ) 
            else:
               cmdSeq.addCommand( 
                  'tunnel decap-interface all' \
                  ' address-family ' + key.addressFamily + \
                  ' address ' + dg.decapIntf[ key ].addressType + excludeIntfOption )

def Plugin( entityManager ):
   pass
