# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliSavePlugin.TeCliSave import RouterGlobalTeMode

RouterGlobalTeMode.addCommandSequence( 'Cspf.config' )

@CliSave.saver( 'Cspf::CspfCliConfig', 'te/cspf/cliConfig' )
def saveCspfTimerConfig( cspfConfig, root, sysdbRoot, options, requireMounts ):
   if cspfConfig.cspfTimer != cspfConfig.cspfThrottleTimerDefault or options.saveAll:
      mode = root[ RouterGlobalTeMode ].getOrCreateModeInstance( "teInstance" )
      cmds = mode[ 'Cspf.config' ]
   if cspfConfig.cspfTimer.cspfBackOffInt != cspfConfig.cspfBackOffIntDefault or \
      cspfConfig.cspfTimer.cspfInitialInt != cspfConfig.cspfInitialIntDefault or \
      options.saveAll:
      cmds.addCommand( 'cspf delay initial %d back-off %d max %d' %
                     ( cspfConfig.cspfTimer.cspfInitialInt,
                        cspfConfig.cspfTimer.cspfBackOffInt,
                        cspfConfig.cspfTimer.cspfMaxInt ) )
   elif cspfConfig.cspfTimer.cspfMaxInt != cspfConfig.cspfMaxIntDefault:
      cmds.addCommand( 'cspf delay max %d' % cspfConfig.cspfTimer.cspfMaxInt )
