# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import CliSave
from CliMode.Cvx import CvxConfigMode as CvxMode

controllerConfigPath = "controller/config"
def getClusterName( controllerConfig ):
   return controllerConfig.primaryClusterName

class CvxConfigMode( CvxMode, CliSave.Mode ):
   def __init__( self, param ):
      CvxMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

CliSave.GlobalConfigMode.addChildMode( CvxConfigMode )
CvxConfigMode.addCommandSequence( "cvx" )

def addCmdsToCvxConfigMode( root, cmds, clusterName ):
   mode = root[ CvxConfigMode ].getOrCreateModeInstance(
      CvxConfigMode.modeName( clusterName ) )
   mode = mode[ "cvx" ]
   for cmd in cmds:
      mode.addCommand( cmd )

def saveOobConfig( cfg, saveAll ):
   timeoutType = Tac.Type( "Controller::Heartbeat::Timeout" )
   intervalType = Tac.Type( "Controller::Heartbeat::Interval" )

   cmds = []
   intervalChanged = cfg.heartbeatConfig.punchInterval != intervalType.defaultVal
   if intervalChanged or saveAll:
      cmds.append( 'heartbeat-interval %d' % cfg.heartbeatConfig.punchInterval )

   timeoutChanged = cfg.heartbeatConfig.timeout != timeoutType.defaultVal
   if timeoutChanged or saveAll:
      cmds.append( 'heartbeat-timeout %d' % cfg.heartbeatConfig.timeout )

   if cfg.sslProfileConfig.sslProfileName or saveAll:
      if cfg.sslProfileConfig.sslProfileName:
         cmds.append( 'ssl profile %s' % ( cfg.sslProfileConfig.sslProfileName ) )
      else:
         cmds.append( 'no ssl profile' )

   if cfg.connectionPreserve or saveAll:
      if cfg.connectionPreserve:
         cmds.append( 'connection state preserve' )
      else:
         cmds.append( 'no connection state preserve' )
   
   return cmds

@CliSave.saver( 'ControllerCluster::ClusterConfigDir',
                'controller/cluster/configDir' )
def saveClusterConfig( cfg, root, sysdbRoot, options ):
   timeoutType = Tac.Type( 'ControllerCluster::PeerTimeout' )
   constants = Tac.Value( "Controller::Constants" )
   saveAll = options.saveAll

   for clusterCfg in cfg.config.itervalues():
      cmds = []

      if clusterCfg.enabled or saveAll:
         cmds += [ "%sshutdown" % ( clusterCfg.enabled and "no " or "" ) ]

      portChanged = clusterCfg.port != constants.controllerdbDefaultPort
      if portChanged or saveAll:
         cmds.append( "port %s" % clusterCfg.port )

      cmds += saveOobConfig( clusterCfg.oobConfig, saveAll )
      
      if not clusterCfg.peerConfig and saveAll:
         cmds.append( 'no peer host' )
      elif clusterCfg.peerConfig:
         for _, peerCfg in clusterCfg.peerConfig.iteritems():
            connectionCfg = peerCfg.connectionConfig
            host = ( connectionCfg.ip if connectionCfg.ip != '0.0.0.0'
                     else connectionCfg.hostname )
            cmds.append( 'peer host %s' % host )

      if clusterCfg.sourceIntf:
         cmds.append( 'source-interface %s' % clusterCfg.sourceIntf )
      elif saveAll:
         cmds.append( 'no source-interface' )

      if saveAll or clusterCfg.peerTimeout != timeoutType.defaultVal:
         cmds.append( 'peer timeout %d' % clusterCfg.peerTimeout )

      clusterName = clusterCfg.clusterName
      if cmds or clusterName:
         addCmdsToCvxConfigMode( root, cmds, clusterName )
