# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliMode.ContainerTracer import CtMode, CtClusterMode
import CliSave
from CliSavePlugin.Controllerdb import ( CvxConfigMode,
                                         controllerConfigPath,
                                         getClusterName as getCvxClusterName )
import Tac

#-------------------------------------------------------------------------------
# ContainerTracer Mode Saver
#-------------------------------------------------------------------------------

class ContainerTracerSaveMode( CtMode, CliSave.Mode ):
   def __init__( self, param ):
      CtMode.__init__( self )
      CliSave.Mode.__init__( self, param )


class ContainerTracerClusterSaveMode( CtClusterMode, CliSave.Mode ):
   def __init__( self, param ):
      CtClusterMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

CvxConfigMode.addChildMode(
   ContainerTracerSaveMode,
   after=[ 'cvx' ]
)

ContainerTracerSaveMode.addCommandSequence(
   'containertracer.config',
   before=[ ContainerTracerClusterSaveMode ]
)

ContainerTracerSaveMode.addChildMode( ContainerTracerClusterSaveMode )
ContainerTracerClusterSaveMode.addCommandSequence( 'containertracer.cluster' )


@CliSave.saver(
   'ContainerTracer::Config',
   'containertracer/config',
   requireMounts=( controllerConfigPath, )
)
def saveContainterTracerConfig( entity, root, sysdbRoot, options, requireMounts):
   # container-tracer mode
   cmds = []

   if entity.enabled or options.saveAll:
      cmds.append( "%sshutdown" % ( "no " if entity.enabled else "" ) )


   if cmds or len( entity.cluster ):
      cvxClusterName = getCvxClusterName( requireMounts[ controllerConfigPath ] )
      cvxMode = root[ CvxConfigMode ].getOrCreateModeInstance(
         CvxConfigMode.modeName( cvxClusterName )
      )

      ctMode = cvxMode[ ContainerTracerSaveMode ].getOrCreateModeInstance(
         'cvx-container-tracer'
      )

      cmdSeq = ctMode[ 'containertracer.config' ]
      for cmd in cmds:
         cmdSeq.addCommand( cmd )
      # cluster mode
      for cluster in entity.cluster.values():
         mode = ctMode[ ContainerTracerClusterSaveMode ].getOrCreateModeInstance(
            cluster.name
         )

         cmdSeq = mode[ 'containertracer.cluster' ]

         if cluster.url:
            cmdSeq.addCommand( 'url %s' % cluster.url )

         if cluster.authSecret:
            cmdSeq.addCommand(
               'auth %s 7 %s' %
               ( cluster.authType,
                 CliSave.sanitizedOutput( options, cluster.authSecret ) )
            )

         if cluster.apiVersion or options.saveAll:
            cmdSeq.addCommand( 'version %s' % cluster.apiVersion )


