# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliMode.ContainerMgrMode import ContainerMgrMode
from CliMode.ContainerMode import ContainerMode
from CliMode.RegistryMode import RegistryMode
import DesCrypt

class ContainerMgrConfigMode( ContainerMgrMode, CliSave.Mode ):
   def __init__( self, param ):
      ContainerMgrMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

CliSave.GlobalConfigMode.addChildMode( ContainerMgrConfigMode )
ContainerMgrConfigMode.addCommandSequence( 'ContainerMgr.config' )

class RegistryConfigMode( RegistryMode, CliSave.Mode ):
   def __init__( self, param ):
      RegistryMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

ContainerMgrConfigMode.addChildMode( RegistryConfigMode )
RegistryConfigMode.addCommandSequence( 'ContainerMgr.registry' )

class ContainerConfigMode( ContainerMode, CliSave.Mode ):
   def __init__( self, param ):
      ContainerMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

ContainerMgrConfigMode.addChildMode( ContainerConfigMode )
ContainerConfigMode.addCommandSequence( 'ContainerMgr.containerConfig' )

@CliSave.saver( 'ContainerMgr::ContainerMgrConfig', 'containerMgr/config' )
def saveContainerMgrConfig( entity, root, sysdbRoot, options ):
   if not entity.daemonEnable:
      return
   mode = root[ ContainerMgrConfigMode ].getOrCreateModeInstance( None )
   cmds = mode[ 'ContainerMgr.config' ]
   saveAll = options.saveAll

   if entity.containerMgrArgs != entity.invalidString:
      cmds.addCommand( 'daemon args %s' % entity.containerMgrArgs )
   elif saveAll:
      cmds.addCommand( 'no daemon args' )

   if entity.persistentPath != entity.defaultPersistentPath:
      cmds.addCommand( 'persistent-path %s' % entity.persistentPath )
   elif saveAll:
      cmds.addCommand( 'no persistent-path' )

   for registry in entity.registryConfig.values():
      saveRegistryConfig( mode, registry, options )

def saveRegistryConfig( root, registry, options ):
   mode = root[ RegistryConfigMode ].getOrCreateModeInstance( registry.name )
   cmdsRegistry = mode[ 'ContainerMgr.registry' ]
   saveAll = options.saveAll

   if registry.insecure:
      cmdsRegistry.addCommand( 'insecure' )
   elif saveAll:
      cmdsRegistry.addCommand( 'no insecure' )

   if registry.userName != registry.invalidString:
      cmdsRegistry.addCommand( 'username %s' % registry.userName )
   elif saveAll:
      cmdsRegistry.addCommand( 'no username' )

   sanitize = lambda word: CliSave.sanitizedOutput( options, word )
   password = sanitize( DesCrypt.encrypt( registry.name, registry.password ) )
   if registry.password != registry.invalidString:
      cmdsRegistry.addCommand( 'password 7 %s' % password )
   elif saveAll:
      cmdsRegistry.addCommand( 'no password' )

   if registry.serverName != registry.invalidString:
      cmdsRegistry.addCommand( 'server %s' % registry.serverName )
   elif saveAll:
      cmdsRegistry.addCommand( 'no server' )

@CliSave.saver( 'ContainerMgr::ContainerConfig', 'containerMgr/container/config' )
def saveContainerConfig(  entity, root, sysdbRoot, options ):
   for container in entity.container.values():
      mode = root[ ContainerMgrConfigMode ].getOrCreateModeInstance(
         None )
      subMode = mode[ ContainerConfigMode ].getOrCreateModeInstance(
         container.containerName )
      containerCmds = subMode[ 'ContainerMgr.containerConfig' ]
      saveAllOptions = options.saveAll or options.saveAllDetail

      if container.imageName:
         containerCmds.addCommand( 'image %s' % container.imageName )
      elif saveAllOptions:
         containerCmds.addCommand( 'no image' )

      if container.onBoot:
         containerCmds.addCommand( 'on-boot' )
      elif saveAllOptions:
         containerCmds.addCommand( 'no on-boot' )

      if container.cpuShares != container.defaultCpuShares or saveAllOptions:
         containerCmds.addCommand( 'cpu shares %s' % container.cpuShares )

      if container.cpuCores != container.defaultCpuCores or saveAllOptions:
         containerCmds.addCommand( 'cpu cores %s' % container.cpuCores )

      if container.memory != container.defaultMemory or saveAllOptions:
         containerCmds.addCommand( 'memory %s' % container.memory )

      if container.options:
         containerCmds.addCommand( 'options %s' % container.options )
      elif saveAllOptions:
         containerCmds.addCommand( 'no options' )

      if container.command:
         containerCmds.addCommand( 'command %s' % container.command )
      elif saveAllOptions:
         containerCmds.addCommand( 'no command' )

